package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFunctionDefaultInstance invokes the opensearch.UpdateFunctionDefaultInstance API synchronously
func (client *Client) UpdateFunctionDefaultInstance(request *UpdateFunctionDefaultInstanceRequest) (response *UpdateFunctionDefaultInstanceResponse, err error) {
	response = CreateUpdateFunctionDefaultInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFunctionDefaultInstanceWithChan invokes the opensearch.UpdateFunctionDefaultInstance API asynchronously
func (client *Client) UpdateFunctionDefaultInstanceWithChan(request *UpdateFunctionDefaultInstanceRequest) (<-chan *UpdateFunctionDefaultInstanceResponse, <-chan error) {
	responseChan := make(chan *UpdateFunctionDefaultInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFunctionDefaultInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFunctionDefaultInstanceWithCallback invokes the opensearch.UpdateFunctionDefaultInstance API asynchronously
func (client *Client) UpdateFunctionDefaultInstanceWithCallback(request *UpdateFunctionDefaultInstanceRequest, callback func(response *UpdateFunctionDefaultInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFunctionDefaultInstanceResponse
		var err error
		defer close(result)
		response, err = client.UpdateFunctionDefaultInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFunctionDefaultInstanceRequest is the request struct for api UpdateFunctionDefaultInstance
type UpdateFunctionDefaultInstanceRequest struct {
	*requests.RoaRequest
	FunctionName     string `position:"Path" name:"functionName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// UpdateFunctionDefaultInstanceResponse is the response struct for api UpdateFunctionDefaultInstance
type UpdateFunctionDefaultInstanceResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	HttpCode  int64  `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Latency   int64  `json:"Latency" xml:"Latency"`
}

// CreateUpdateFunctionDefaultInstanceRequest creates a request to invoke UpdateFunctionDefaultInstance API
func CreateUpdateFunctionDefaultInstanceRequest() (request *UpdateFunctionDefaultInstanceRequest) {
	request = &UpdateFunctionDefaultInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UpdateFunctionDefaultInstance", "/v4/openapi/app-groups/[appGroupIdentity]/functions/[functionName]/default-instance", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateFunctionDefaultInstanceResponse creates a response to parse from UpdateFunctionDefaultInstance response
func CreateUpdateFunctionDefaultInstanceResponse() (response *UpdateFunctionDefaultInstanceResponse) {
	response = &UpdateFunctionDefaultInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
