package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySecondRank invokes the opensearch.ModifySecondRank API synchronously
func (client *Client) ModifySecondRank(request *ModifySecondRankRequest) (response *ModifySecondRankResponse, err error) {
	response = CreateModifySecondRankResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySecondRankWithChan invokes the opensearch.ModifySecondRank API asynchronously
func (client *Client) ModifySecondRankWithChan(request *ModifySecondRankRequest) (<-chan *ModifySecondRankResponse, <-chan error) {
	responseChan := make(chan *ModifySecondRankResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySecondRank(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySecondRankWithCallback invokes the opensearch.ModifySecondRank API asynchronously
func (client *Client) ModifySecondRankWithCallback(request *ModifySecondRankRequest, callback func(response *ModifySecondRankResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySecondRankResponse
		var err error
		defer close(result)
		response, err = client.ModifySecondRank(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySecondRankRequest is the request struct for api ModifySecondRank
type ModifySecondRankRequest struct {
	*requests.RoaRequest
	DryRun           requests.Boolean `position:"Query" name:"dryRun"`
	AppId            requests.Integer `position:"Path" name:"appId"`
	Name             string           `position:"Path" name:"name"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// ModifySecondRankResponse is the response struct for api ModifySecondRank
type ModifySecondRankResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"requestId" xml:"requestId"`
	Result    ResultInModifySecondRank `json:"result" xml:"result"`
}

// CreateModifySecondRankRequest creates a request to invoke ModifySecondRank API
func CreateModifySecondRankRequest() (request *ModifySecondRankRequest) {
	request = &ModifySecondRankRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ModifySecondRank", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/second-ranks/[name]", "", "")
	request.Method = requests.PUT
	return
}

// CreateModifySecondRankResponse creates a response to parse from ModifySecondRank response
func CreateModifySecondRankResponse() (response *ModifySecondRankResponse) {
	response = &ModifySecondRankResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
