package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchKillSessionList invokes the oceanbasepro.BatchKillSessionList API synchronously
func (client *Client) BatchKillSessionList(request *BatchKillSessionListRequest) (response *BatchKillSessionListResponse, err error) {
	response = CreateBatchKillSessionListResponse()
	err = client.DoAction(request, response)
	return
}

// BatchKillSessionListWithChan invokes the oceanbasepro.BatchKillSessionList API asynchronously
func (client *Client) BatchKillSessionListWithChan(request *BatchKillSessionListRequest) (<-chan *BatchKillSessionListResponse, <-chan error) {
	responseChan := make(chan *BatchKillSessionListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchKillSessionList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchKillSessionListWithCallback invokes the oceanbasepro.BatchKillSessionList API asynchronously
func (client *Client) BatchKillSessionListWithCallback(request *BatchKillSessionListRequest, callback func(response *BatchKillSessionListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchKillSessionListResponse
		var err error
		defer close(result)
		response, err = client.BatchKillSessionList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchKillSessionListRequest is the request struct for api BatchKillSessionList
type BatchKillSessionListRequest struct {
	*requests.RpcRequest
	SessionList string `position:"Body" name:"SessionList"`
	InstanceId  string `position:"Body" name:"InstanceId"`
	TenantId    string `position:"Body" name:"TenantId"`
}

// BatchKillSessionListResponse is the response struct for api BatchKillSessionList
type BatchKillSessionListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchKillSessionListRequest creates a request to invoke BatchKillSessionList API
func CreateBatchKillSessionListRequest() (request *BatchKillSessionListRequest) {
	request = &BatchKillSessionListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "BatchKillSessionList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchKillSessionListResponse creates a response to parse from BatchKillSessionList response
func CreateBatchKillSessionListResponse() (response *BatchKillSessionListResponse) {
	response = &BatchKillSessionListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
