package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRoleByOperator invokes the oam.ListRoleByOperator API synchronously
// api document: https://help.aliyun.com/api/oam/listrolebyoperator.html
func (client *Client) ListRoleByOperator(request *ListRoleByOperatorRequest) (response *ListRoleByOperatorResponse, err error) {
	response = CreateListRoleByOperatorResponse()
	err = client.DoAction(request, response)
	return
}

// ListRoleByOperatorWithChan invokes the oam.ListRoleByOperator API asynchronously
// api document: https://help.aliyun.com/api/oam/listrolebyoperator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRoleByOperatorWithChan(request *ListRoleByOperatorRequest) (<-chan *ListRoleByOperatorResponse, <-chan error) {
	responseChan := make(chan *ListRoleByOperatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRoleByOperator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRoleByOperatorWithCallback invokes the oam.ListRoleByOperator API asynchronously
// api document: https://help.aliyun.com/api/oam/listrolebyoperator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRoleByOperatorWithCallback(request *ListRoleByOperatorRequest, callback func(response *ListRoleByOperatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRoleByOperatorResponse
		var err error
		defer close(result)
		response, err = client.ListRoleByOperator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRoleByOperatorRequest is the request struct for api ListRoleByOperator
type ListRoleByOperatorRequest struct {
	*requests.RpcRequest
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	UserType     string           `position:"Query" name:"UserType"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
	OperatorName string           `position:"Query" name:"OperatorName"`
}

// ListRoleByOperatorResponse is the response struct for api ListRoleByOperator
type ListRoleByOperatorResponse struct {
	*responses.BaseResponse
	Code     string                   `json:"Code" xml:"Code"`
	Message  string                   `json:"Message" xml:"Message"`
	PageInfo PageInfo                 `json:"PageInfo" xml:"PageInfo"`
	Data     DataInListRoleByOperator `json:"Data" xml:"Data"`
}

// CreateListRoleByOperatorRequest creates a request to invoke ListRoleByOperator API
func CreateListRoleByOperatorRequest() (request *ListRoleByOperatorRequest) {
	request = &ListRoleByOperatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListRoleByOperator", "", "")
	request.Method = requests.POST
	return
}

// CreateListRoleByOperatorResponse creates a response to parse from ListRoleByOperator response
func CreateListRoleByOperatorResponse() (response *ListRoleByOperatorResponse) {
	response = &ListRoleByOperatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
