package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVbrFlowTopN invokes the nis.GetVbrFlowTopN API synchronously
func (client *Client) GetVbrFlowTopN(request *GetVbrFlowTopNRequest) (response *GetVbrFlowTopNResponse, err error) {
	response = CreateGetVbrFlowTopNResponse()
	err = client.DoAction(request, response)
	return
}

// GetVbrFlowTopNWithChan invokes the nis.GetVbrFlowTopN API asynchronously
func (client *Client) GetVbrFlowTopNWithChan(request *GetVbrFlowTopNRequest) (<-chan *GetVbrFlowTopNResponse, <-chan error) {
	responseChan := make(chan *GetVbrFlowTopNResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVbrFlowTopN(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVbrFlowTopNWithCallback invokes the nis.GetVbrFlowTopN API asynchronously
func (client *Client) GetVbrFlowTopNWithCallback(request *GetVbrFlowTopNRequest, callback func(response *GetVbrFlowTopNResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVbrFlowTopNResponse
		var err error
		defer close(result)
		response, err = client.GetVbrFlowTopN(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVbrFlowTopNRequest is the request struct for api GetVbrFlowTopN
type GetVbrFlowTopNRequest struct {
	*requests.RpcRequest
	OtherPort             string           `position:"Query" name:"OtherPort"`
	TopN                  requests.Integer `position:"Query" name:"TopN"`
	CloudPort             string           `position:"Query" name:"CloudPort"`
	Protocol              string           `position:"Query" name:"Protocol"`
	OtherIp               string           `position:"Query" name:"OtherIp"`
	OrderBy               string           `position:"Query" name:"OrderBy"`
	Sort                  string           `position:"Query" name:"Sort"`
	UseMultiAccount       requests.Boolean `position:"Query" name:"UseMultiAccount"`
	CloudIp               string           `position:"Query" name:"CloudIp"`
	CenId                 string           `position:"Query" name:"CenId"`
	VirtualBorderRouterId string           `position:"Query" name:"VirtualBorderRouterId"`
	Direction             string           `position:"Query" name:"Direction"`
	EndTime               requests.Integer `position:"Query" name:"EndTime"`
	BeginTime             requests.Integer `position:"Query" name:"BeginTime"`
	GroupBy               string           `position:"Query" name:"GroupBy"`
	AccountIds            *[]string        `position:"Query" name:"AccountIds"  type:"Json"`
	AttachmentId          string           `position:"Query" name:"AttachmentId"`
}

// GetVbrFlowTopNResponse is the response struct for api GetVbrFlowTopN
type GetVbrFlowTopNResponse struct {
	*responses.BaseResponse
	RequestId                      string           `json:"RequestId" xml:"RequestId"`
	VirtualBorderRouterFlowlogTopN []VbrFlowlogTopN `json:"VirtualBorderRouterFlowlogTopN" xml:"VirtualBorderRouterFlowlogTopN"`
}

// CreateGetVbrFlowTopNRequest creates a request to invoke GetVbrFlowTopN API
func CreateGetVbrFlowTopNRequest() (request *GetVbrFlowTopNRequest) {
	request = &GetVbrFlowTopNRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "GetVbrFlowTopN", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVbrFlowTopNResponse creates a response to parse from GetVbrFlowTopN response
func CreateGetVbrFlowTopNResponse() (response *GetVbrFlowTopNResponse) {
	response = &GetVbrFlowTopNResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
