package netana

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNetworkAnalyticsPacketLoss invokes the netana.DescribeNetworkAnalyticsPacketLoss API synchronously
// api document: https://help.aliyun.com/api/netana/describenetworkanalyticspacketloss.html
func (client *Client) DescribeNetworkAnalyticsPacketLoss(request *DescribeNetworkAnalyticsPacketLossRequest) (response *DescribeNetworkAnalyticsPacketLossResponse, err error) {
	response = CreateDescribeNetworkAnalyticsPacketLossResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNetworkAnalyticsPacketLossWithChan invokes the netana.DescribeNetworkAnalyticsPacketLoss API asynchronously
// api document: https://help.aliyun.com/api/netana/describenetworkanalyticspacketloss.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkAnalyticsPacketLossWithChan(request *DescribeNetworkAnalyticsPacketLossRequest) (<-chan *DescribeNetworkAnalyticsPacketLossResponse, <-chan error) {
	responseChan := make(chan *DescribeNetworkAnalyticsPacketLossResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNetworkAnalyticsPacketLoss(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNetworkAnalyticsPacketLossWithCallback invokes the netana.DescribeNetworkAnalyticsPacketLoss API asynchronously
// api document: https://help.aliyun.com/api/netana/describenetworkanalyticspacketloss.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkAnalyticsPacketLossWithCallback(request *DescribeNetworkAnalyticsPacketLossRequest, callback func(response *DescribeNetworkAnalyticsPacketLossResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNetworkAnalyticsPacketLossResponse
		var err error
		defer close(result)
		response, err = client.DescribeNetworkAnalyticsPacketLoss(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNetworkAnalyticsPacketLossRequest is the request struct for api DescribeNetworkAnalyticsPacketLoss
type DescribeNetworkAnalyticsPacketLossRequest struct {
	*requests.RpcRequest
	Country              string           `position:"Query" name:"Country"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Product              string           `position:"Query" name:"Product"`
	Period               string           `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Ip                   string           `position:"Query" name:"Ip"`
	EndTime              string           `position:"Query" name:"EndTime"`
	StartTime            string           `position:"Query" name:"StartTime"`
	PageNumber           string           `position:"Query" name:"PageNumber"`
	Carrier              string           `position:"Query" name:"Carrier"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Province             string           `position:"Query" name:"Province"`
	InternetChargeType   string           `position:"Query" name:"InternetChargeType"`
	Grade                string           `position:"Query" name:"Grade"`
	PageSize             string           `position:"Query" name:"PageSize"`
	Direction            string           `position:"Query" name:"Direction"`
}

// DescribeNetworkAnalyticsPacketLossResponse is the response struct for api DescribeNetworkAnalyticsPacketLoss
type DescribeNetworkAnalyticsPacketLossResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	TotalCount      int             `json:"TotalCount" xml:"TotalCount"`
	PageNumber      int             `json:"PageNumber" xml:"PageNumber"`
	PageSize        int             `json:"PageSize" xml:"PageSize"`
	PacketLossInfos PacketLossInfos `json:"PacketLossInfos" xml:"PacketLossInfos"`
}

// CreateDescribeNetworkAnalyticsPacketLossRequest creates a request to invoke DescribeNetworkAnalyticsPacketLoss API
func CreateDescribeNetworkAnalyticsPacketLossRequest() (request *DescribeNetworkAnalyticsPacketLossRequest) {
	request = &DescribeNetworkAnalyticsPacketLossRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Netana", "2018-10-18", "DescribeNetworkAnalyticsPacketLoss", "Netana", "openAPI")
	return
}

// CreateDescribeNetworkAnalyticsPacketLossResponse creates a response to parse from DescribeNetworkAnalyticsPacketLoss response
func CreateDescribeNetworkAnalyticsPacketLossResponse() (response *DescribeNetworkAnalyticsPacketLossResponse) {
	response = &DescribeNetworkAnalyticsPacketLossResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
