package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogAnalysis invokes the nas.DescribeLogAnalysis API synchronously
func (client *Client) DescribeLogAnalysis(request *DescribeLogAnalysisRequest) (response *DescribeLogAnalysisResponse, err error) {
	response = CreateDescribeLogAnalysisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogAnalysisWithChan invokes the nas.DescribeLogAnalysis API asynchronously
func (client *Client) DescribeLogAnalysisWithChan(request *DescribeLogAnalysisRequest) (<-chan *DescribeLogAnalysisResponse, <-chan error) {
	responseChan := make(chan *DescribeLogAnalysisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogAnalysis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogAnalysisWithCallback invokes the nas.DescribeLogAnalysis API asynchronously
func (client *Client) DescribeLogAnalysisWithCallback(request *DescribeLogAnalysisRequest, callback func(response *DescribeLogAnalysisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogAnalysisResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogAnalysis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogAnalysisRequest is the request struct for api DescribeLogAnalysis
type DescribeLogAnalysisRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeLogAnalysisResponse is the response struct for api DescribeLogAnalysis
type DescribeLogAnalysisResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Code       string   `json:"Code" xml:"Code"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	Analyses   Analyses `json:"Analyses" xml:"Analyses"`
}

// CreateDescribeLogAnalysisRequest creates a request to invoke DescribeLogAnalysis API
func CreateDescribeLogAnalysisRequest() (request *DescribeLogAnalysisRequest) {
	request = &DescribeLogAnalysisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeLogAnalysis", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLogAnalysisResponse creates a response to parse from DescribeLogAnalysis response
func CreateDescribeLogAnalysisResponse() (response *DescribeLogAnalysisResponse) {
	response = &DescribeLogAnalysisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
