package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayRouteAuth invokes the mse.UpdateGatewayRouteAuth API synchronously
func (client *Client) UpdateGatewayRouteAuth(request *UpdateGatewayRouteAuthRequest) (response *UpdateGatewayRouteAuthResponse, err error) {
	response = CreateUpdateGatewayRouteAuthResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayRouteAuthWithChan invokes the mse.UpdateGatewayRouteAuth API asynchronously
func (client *Client) UpdateGatewayRouteAuthWithChan(request *UpdateGatewayRouteAuthRequest) (<-chan *UpdateGatewayRouteAuthResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayRouteAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayRouteAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayRouteAuthWithCallback invokes the mse.UpdateGatewayRouteAuth API asynchronously
func (client *Client) UpdateGatewayRouteAuthWithCallback(request *UpdateGatewayRouteAuthRequest, callback func(response *UpdateGatewayRouteAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayRouteAuthResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayRouteAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayRouteAuthRequest is the request struct for api UpdateGatewayRouteAuth
type UpdateGatewayRouteAuthRequest struct {
	*requests.RpcRequest
	MseSessionId    string                         `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string                         `position:"Query" name:"GatewayUniqueId"`
	Id              requests.Integer               `position:"Query" name:"Id"`
	GatewayId       requests.Integer               `position:"Query" name:"GatewayId"`
	AcceptLanguage  string                         `position:"Query" name:"AcceptLanguage"`
	AuthJSON        UpdateGatewayRouteAuthAuthJSON `position:"Query" name:"AuthJSON"  type:"Struct"`
}

// UpdateGatewayRouteAuthAuthJSON is a repeated param struct in UpdateGatewayRouteAuthRequest
type UpdateGatewayRouteAuthAuthJSON struct {
	Type string `name:"Type"`
}

// UpdateGatewayRouteAuthResponse is the response struct for api UpdateGatewayRouteAuth
type UpdateGatewayRouteAuthResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayRouteAuthRequest creates a request to invoke UpdateGatewayRouteAuth API
func CreateUpdateGatewayRouteAuthRequest() (request *UpdateGatewayRouteAuthRequest) {
	request = &UpdateGatewayRouteAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayRouteAuth", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayRouteAuthResponse creates a response to parse from UpdateGatewayRouteAuth response
func CreateUpdateGatewayRouteAuthResponse() (response *UpdateGatewayRouteAuthResponse) {
	response = &UpdateGatewayRouteAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
