package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGatewayAuthDetail invokes the mse.GetGatewayAuthDetail API synchronously
func (client *Client) GetGatewayAuthDetail(request *GetGatewayAuthDetailRequest) (response *GetGatewayAuthDetailResponse, err error) {
	response = CreateGetGatewayAuthDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetGatewayAuthDetailWithChan invokes the mse.GetGatewayAuthDetail API asynchronously
func (client *Client) GetGatewayAuthDetailWithChan(request *GetGatewayAuthDetailRequest) (<-chan *GetGatewayAuthDetailResponse, <-chan error) {
	responseChan := make(chan *GetGatewayAuthDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGatewayAuthDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGatewayAuthDetailWithCallback invokes the mse.GetGatewayAuthDetail API asynchronously
func (client *Client) GetGatewayAuthDetailWithCallback(request *GetGatewayAuthDetailRequest, callback func(response *GetGatewayAuthDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGatewayAuthDetailResponse
		var err error
		defer close(result)
		response, err = client.GetGatewayAuthDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGatewayAuthDetailRequest is the request struct for api GetGatewayAuthDetail
type GetGatewayAuthDetailRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Id              requests.Integer `position:"Query" name:"Id"`
	GatewayId       requests.Integer `position:"Query" name:"GatewayId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// GetGatewayAuthDetailResponse is the response struct for api GetGatewayAuthDetail
type GetGatewayAuthDetailResponse struct {
	*responses.BaseResponse
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                     `json:"Message" xml:"Message"`
	Code           int                        `json:"Code" xml:"Code"`
	Success        bool                       `json:"Success" xml:"Success"`
	Data           DataInGetGatewayAuthDetail `json:"Data" xml:"Data"`
}

// CreateGetGatewayAuthDetailRequest creates a request to invoke GetGatewayAuthDetail API
func CreateGetGatewayAuthDetailRequest() (request *GetGatewayAuthDetailRequest) {
	request = &GetGatewayAuthDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetGatewayAuthDetail", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetGatewayAuthDetailResponse creates a response to parse from GetGatewayAuthDetail response
func CreateGetGatewayAuthDetailResponse() (response *GetGatewayAuthDetailResponse) {
	response = &GetGatewayAuthDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
