package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePluginConfig invokes the mse.CreatePluginConfig API synchronously
func (client *Client) CreatePluginConfig(request *CreatePluginConfigRequest) (response *CreatePluginConfigResponse, err error) {
	response = CreateCreatePluginConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePluginConfigWithChan invokes the mse.CreatePluginConfig API asynchronously
func (client *Client) CreatePluginConfigWithChan(request *CreatePluginConfigRequest) (<-chan *CreatePluginConfigResponse, <-chan error) {
	responseChan := make(chan *CreatePluginConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePluginConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePluginConfigWithCallback invokes the mse.CreatePluginConfig API asynchronously
func (client *Client) CreatePluginConfigWithCallback(request *CreatePluginConfigRequest, callback func(response *CreatePluginConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePluginConfigResponse
		var err error
		defer close(result)
		response, err = client.CreatePluginConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePluginConfigRequest is the request struct for api CreatePluginConfig
type CreatePluginConfigRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	ResourceIdList  *[]string        `position:"Query" name:"ResourceIdList"  type:"Json"`
	Enable          requests.Boolean `position:"Query" name:"Enable"`
	PluginId        requests.Integer `position:"Query" name:"PluginId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	ConfigLevel     requests.Integer `position:"Query" name:"ConfigLevel"`
	Config          string           `position:"Query" name:"Config"`
}

// CreatePluginConfigResponse is the response struct for api CreatePluginConfig
type CreatePluginConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	PluginConfigID int64  `json:"PluginConfigID" xml:"PluginConfigID"`
}

// CreateCreatePluginConfigRequest creates a request to invoke CreatePluginConfig API
func CreateCreatePluginConfigRequest() (request *CreatePluginConfigRequest) {
	request = &CreatePluginConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreatePluginConfig", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePluginConfigResponse creates a response to parse from CreatePluginConfig response
func CreateCreatePluginConfigResponse() (response *CreatePluginConfigResponse) {
	response = &CreatePluginConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
