package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOrg invokes the mpaas.GetOrg API synchronously
func (client *Client) GetOrg(request *GetOrgRequest) (response *GetOrgResponse, err error) {
	response = CreateGetOrgResponse()
	err = client.DoAction(request, response)
	return
}

// GetOrgWithChan invokes the mpaas.GetOrg API asynchronously
func (client *Client) GetOrgWithChan(request *GetOrgRequest) (<-chan *GetOrgResponse, <-chan error) {
	responseChan := make(chan *GetOrgResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOrg(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOrgWithCallback invokes the mpaas.GetOrg API asynchronously
func (client *Client) GetOrgWithCallback(request *GetOrgRequest, callback func(response *GetOrgResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOrgResponse
		var err error
		defer close(result)
		response, err = client.GetOrg(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOrgRequest is the request struct for api GetOrg
type GetOrgRequest struct {
	*requests.RpcRequest
	CustomerId requests.Integer `position:"Query" name:"CustomerId"`
}

// GetOrgResponse is the response struct for api GetOrg
type GetOrgResponse struct {
	*responses.BaseResponse
}

// CreateGetOrgRequest creates a request to invoke GetOrg API
func CreateGetOrgRequest() (request *GetOrgRequest) {
	request = &GetOrgRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetOrg", "", "")
	request.Method = requests.GET
	return
}

// CreateGetOrgResponse creates a response to parse from GetOrg response
func CreateGetOrgResponse() (response *GetOrgResponse) {
	response = &GetOrgResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
