package mopen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoPenBindIsv invokes the mopen.MoPenBindIsv API synchronously
// api document: https://help.aliyun.com/api/mopen/mopenbindisv.html
func (client *Client) MoPenBindIsv(request *MoPenBindIsvRequest) (response *MoPenBindIsvResponse, err error) {
	response = CreateMoPenBindIsvResponse()
	err = client.DoAction(request, response)
	return
}

// MoPenBindIsvWithChan invokes the mopen.MoPenBindIsv API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenbindisv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenBindIsvWithChan(request *MoPenBindIsvRequest) (<-chan *MoPenBindIsvResponse, <-chan error) {
	responseChan := make(chan *MoPenBindIsvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoPenBindIsv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoPenBindIsvWithCallback invokes the mopen.MoPenBindIsv API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenbindisv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenBindIsvWithCallback(request *MoPenBindIsvRequest, callback func(response *MoPenBindIsvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoPenBindIsvResponse
		var err error
		defer close(result)
		response, err = client.MoPenBindIsv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoPenBindIsvRequest is the request struct for api MoPenBindIsv
type MoPenBindIsvRequest struct {
	*requests.RpcRequest
	OrderKey   string `position:"Body" name:"OrderKey"`
	DeviceName string `position:"Body" name:"DeviceName"`
}

// MoPenBindIsvResponse is the response struct for api MoPenBindIsv
type MoPenBindIsvResponse struct {
	*responses.BaseResponse
	Code        bool   `json:"Code" xml:"Code"`
	Message     string `json:"Message" xml:"Message"`
	Success     bool   `json:"Success" xml:"Success"`
	Description string `json:"Description" xml:"Description"`
}

// CreateMoPenBindIsvRequest creates a request to invoke MoPenBindIsv API
func CreateMoPenBindIsvRequest() (request *MoPenBindIsvRequest) {
	request = &MoPenBindIsvRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("MoPen", "2018-02-11", "MoPenBindIsv", "mopen", "openAPI")
	return
}

// CreateMoPenBindIsvResponse creates a response to parse from MoPenBindIsv response
func CreateMoPenBindIsvResponse() (response *MoPenBindIsvResponse) {
	response = &MoPenBindIsvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
