package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushMeteringData invokes the market.PushMeteringData API synchronously
func (client *Client) PushMeteringData(request *PushMeteringDataRequest) (response *PushMeteringDataResponse, err error) {
	response = CreatePushMeteringDataResponse()
	err = client.DoAction(request, response)
	return
}

// PushMeteringDataWithChan invokes the market.PushMeteringData API asynchronously
func (client *Client) PushMeteringDataWithChan(request *PushMeteringDataRequest) (<-chan *PushMeteringDataResponse, <-chan error) {
	responseChan := make(chan *PushMeteringDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushMeteringData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushMeteringDataWithCallback invokes the market.PushMeteringData API asynchronously
func (client *Client) PushMeteringDataWithCallback(request *PushMeteringDataRequest, callback func(response *PushMeteringDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushMeteringDataResponse
		var err error
		defer close(result)
		response, err = client.PushMeteringData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushMeteringDataRequest is the request struct for api PushMeteringData
type PushMeteringDataRequest struct {
	*requests.RpcRequest
	Metering string `position:"Query" name:"Metering"`
}

// PushMeteringDataResponse is the response struct for api PushMeteringData
type PushMeteringDataResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePushMeteringDataRequest creates a request to invoke PushMeteringData API
func CreatePushMeteringDataRequest() (request *PushMeteringDataRequest) {
	request = &PushMeteringDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "PushMeteringData", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePushMeteringDataResponse creates a response to parse from PushMeteringData response
func CreatePushMeteringDataResponse() (response *PushMeteringDataResponse) {
	response = &PushMeteringDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
