package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProjectMessages invokes the market.DescribeProjectMessages API synchronously
func (client *Client) DescribeProjectMessages(request *DescribeProjectMessagesRequest) (response *DescribeProjectMessagesResponse, err error) {
	response = CreateDescribeProjectMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProjectMessagesWithChan invokes the market.DescribeProjectMessages API asynchronously
func (client *Client) DescribeProjectMessagesWithChan(request *DescribeProjectMessagesRequest) (<-chan *DescribeProjectMessagesResponse, <-chan error) {
	responseChan := make(chan *DescribeProjectMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProjectMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProjectMessagesWithCallback invokes the market.DescribeProjectMessages API asynchronously
func (client *Client) DescribeProjectMessagesWithCallback(request *DescribeProjectMessagesRequest, callback func(response *DescribeProjectMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProjectMessagesResponse
		var err error
		defer close(result)
		response, err = client.DescribeProjectMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProjectMessagesRequest is the request struct for api DescribeProjectMessages
type DescribeProjectMessagesRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageIndex  requests.Integer `position:"Query" name:"PageIndex"`
}

// DescribeProjectMessagesResponse is the response struct for api DescribeProjectMessages
type DescribeProjectMessagesResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	TotalCount int64            `json:"TotalCount" xml:"TotalCount"`
	Success    bool             `json:"Success" xml:"Success"`
	Result     []ProjectMessage `json:"Result" xml:"Result"`
}

// CreateDescribeProjectMessagesRequest creates a request to invoke DescribeProjectMessages API
func CreateDescribeProjectMessagesRequest() (request *DescribeProjectMessagesRequest) {
	request = &DescribeProjectMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeProjectMessages", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProjectMessagesResponse creates a response to parse from DescribeProjectMessages response
func CreateDescribeProjectMessagesResponse() (response *DescribeProjectMessagesResponse) {
	response = &DescribeProjectMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
