package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProjectInfo invokes the market.DescribeProjectInfo API synchronously
func (client *Client) DescribeProjectInfo(request *DescribeProjectInfoRequest) (response *DescribeProjectInfoResponse, err error) {
	response = CreateDescribeProjectInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProjectInfoWithChan invokes the market.DescribeProjectInfo API asynchronously
func (client *Client) DescribeProjectInfoWithChan(request *DescribeProjectInfoRequest) (<-chan *DescribeProjectInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeProjectInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProjectInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProjectInfoWithCallback invokes the market.DescribeProjectInfo API asynchronously
func (client *Client) DescribeProjectInfoWithCallback(request *DescribeProjectInfoRequest, callback func(response *DescribeProjectInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProjectInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeProjectInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProjectInfoRequest is the request struct for api DescribeProjectInfo
type DescribeProjectInfoRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeProjectInfoResponse is the response struct for api DescribeProjectInfo
type DescribeProjectInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeProjectInfoRequest creates a request to invoke DescribeProjectInfo API
func CreateDescribeProjectInfoRequest() (request *DescribeProjectInfoRequest) {
	request = &DescribeProjectInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeProjectInfo", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProjectInfoResponse creates a response to parse from DescribeProjectInfo response
func CreateDescribeProjectInfoResponse() (response *DescribeProjectInfoResponse) {
	response = &DescribeProjectInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
