package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllPrivacyRule invokes the lto.ListAllPrivacyRule API synchronously
func (client *Client) ListAllPrivacyRule(request *ListAllPrivacyRuleRequest) (response *ListAllPrivacyRuleResponse, err error) {
	response = CreateListAllPrivacyRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllPrivacyRuleWithChan invokes the lto.ListAllPrivacyRule API asynchronously
func (client *Client) ListAllPrivacyRuleWithChan(request *ListAllPrivacyRuleRequest) (<-chan *ListAllPrivacyRuleResponse, <-chan error) {
	responseChan := make(chan *ListAllPrivacyRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllPrivacyRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllPrivacyRuleWithCallback invokes the lto.ListAllPrivacyRule API asynchronously
func (client *Client) ListAllPrivacyRuleWithCallback(request *ListAllPrivacyRuleRequest, callback func(response *ListAllPrivacyRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllPrivacyRuleResponse
		var err error
		defer close(result)
		response, err = client.ListAllPrivacyRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllPrivacyRuleRequest is the request struct for api ListAllPrivacyRule
type ListAllPrivacyRuleRequest struct {
	*requests.RpcRequest
}

// ListAllPrivacyRuleResponse is the response struct for api ListAllPrivacyRule
type ListAllPrivacyRuleResponse struct {
	*responses.BaseResponse
	Code           string            `json:"Code" xml:"Code"`
	HttpStatusCode int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string            `json:"Message" xml:"Message"`
	RequestId      string            `json:"RequestId" xml:"RequestId"`
	Success        bool              `json:"Success" xml:"Success"`
	Data           []PrivacyRuleInfo `json:"Data" xml:"Data"`
}

// CreateListAllPrivacyRuleRequest creates a request to invoke ListAllPrivacyRule API
func CreateListAllPrivacyRuleRequest() (request *ListAllPrivacyRuleRequest) {
	request = &ListAllPrivacyRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListAllPrivacyRule", "", "")
	request.Method = requests.POST
	return
}

// CreateListAllPrivacyRuleResponse creates a response to parse from ListAllPrivacyRule response
func CreateListAllPrivacyRuleResponse() (response *ListAllPrivacyRuleResponse) {
	response = &ListAllPrivacyRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
