package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMPCoSPhaseInfo invokes the ltl.DescribeMPCoSPhaseInfo API synchronously
func (client *Client) DescribeMPCoSPhaseInfo(request *DescribeMPCoSPhaseInfoRequest) (response *DescribeMPCoSPhaseInfoResponse, err error) {
	response = CreateDescribeMPCoSPhaseInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMPCoSPhaseInfoWithChan invokes the ltl.DescribeMPCoSPhaseInfo API asynchronously
func (client *Client) DescribeMPCoSPhaseInfoWithChan(request *DescribeMPCoSPhaseInfoRequest) (<-chan *DescribeMPCoSPhaseInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeMPCoSPhaseInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMPCoSPhaseInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMPCoSPhaseInfoWithCallback invokes the ltl.DescribeMPCoSPhaseInfo API asynchronously
func (client *Client) DescribeMPCoSPhaseInfoWithCallback(request *DescribeMPCoSPhaseInfoRequest, callback func(response *DescribeMPCoSPhaseInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMPCoSPhaseInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeMPCoSPhaseInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMPCoSPhaseInfoRequest is the request struct for api DescribeMPCoSPhaseInfo
type DescribeMPCoSPhaseInfoRequest struct {
	*requests.RpcRequest
	DataKey      string `position:"Query" name:"DataKey"`
	DataSeq      string `position:"Query" name:"DataSeq"`
	PhaseId      string `position:"Query" name:"PhaseId"`
	PhaseGroupId string `position:"Query" name:"PhaseGroupId"`
	ApiVersion   string `position:"Query" name:"ApiVersion"`
	BizChainId   string `position:"Query" name:"BizChainId"`
}

// DescribeMPCoSPhaseInfoResponse is the response struct for api DescribeMPCoSPhaseInfo
type DescribeMPCoSPhaseInfoResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeMPCoSPhaseInfoRequest creates a request to invoke DescribeMPCoSPhaseInfo API
func CreateDescribeMPCoSPhaseInfoRequest() (request *DescribeMPCoSPhaseInfoRequest) {
	request = &DescribeMPCoSPhaseInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "DescribeMPCoSPhaseInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMPCoSPhaseInfoResponse creates a response to parse from DescribeMPCoSPhaseInfo response
func CreateDescribeMPCoSPhaseInfoResponse() (response *DescribeMPCoSPhaseInfoResponse) {
	response = &DescribeMPCoSPhaseInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
