package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLivePackageConfig invokes the live.AddLivePackageConfig API synchronously
func (client *Client) AddLivePackageConfig(request *AddLivePackageConfigRequest) (response *AddLivePackageConfigResponse, err error) {
	response = CreateAddLivePackageConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLivePackageConfigWithChan invokes the live.AddLivePackageConfig API asynchronously
func (client *Client) AddLivePackageConfigWithChan(request *AddLivePackageConfigRequest) (<-chan *AddLivePackageConfigResponse, <-chan error) {
	responseChan := make(chan *AddLivePackageConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLivePackageConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLivePackageConfigWithCallback invokes the live.AddLivePackageConfig API asynchronously
func (client *Client) AddLivePackageConfigWithCallback(request *AddLivePackageConfigRequest, callback func(response *AddLivePackageConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLivePackageConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLivePackageConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLivePackageConfigRequest is the request struct for api AddLivePackageConfig
type AddLivePackageConfigRequest struct {
	*requests.RpcRequest
	SegmentNum      requests.Integer `position:"Query" name:"SegmentNum"`
	Protocol        string           `position:"Query" name:"Protocol"`
	AppName         string           `position:"Query" name:"AppName"`
	PartDuration    requests.Integer `position:"Query" name:"PartDuration"`
	StreamName      string           `position:"Query" name:"StreamName"`
	IgnoreTranscode requests.Boolean `position:"Query" name:"IgnoreTranscode"`
	DomainName      string           `position:"Query" name:"DomainName"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	SegmentDuration requests.Integer `position:"Query" name:"SegmentDuration"`
}

// AddLivePackageConfigResponse is the response struct for api AddLivePackageConfig
type AddLivePackageConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLivePackageConfigRequest creates a request to invoke AddLivePackageConfig API
func CreateAddLivePackageConfigRequest() (request *AddLivePackageConfigRequest) {
	request = &AddLivePackageConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLivePackageConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLivePackageConfigResponse creates a response to parse from AddLivePackageConfig response
func CreateAddLivePackageConfigResponse() (response *AddLivePackageConfigResponse) {
	response = &AddLivePackageConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
