package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePicture invokes the linkvisual.DeletePicture API synchronously
func (client *Client) DeletePicture(request *DeletePictureRequest) (response *DeletePictureResponse, err error) {
	response = CreateDeletePictureResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePictureWithChan invokes the linkvisual.DeletePicture API asynchronously
func (client *Client) DeletePictureWithChan(request *DeletePictureRequest) (<-chan *DeletePictureResponse, <-chan error) {
	responseChan := make(chan *DeletePictureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePicture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePictureWithCallback invokes the linkvisual.DeletePicture API asynchronously
func (client *Client) DeletePictureWithCallback(request *DeletePictureRequest, callback func(response *DeletePictureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePictureResponse
		var err error
		defer close(result)
		response, err = client.DeletePicture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePictureRequest is the request struct for api DeletePicture
type DeletePictureRequest struct {
	*requests.RpcRequest
	IotId         string    `position:"Query" name:"IotId"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	PictureIdList *[]string `position:"Query" name:"PictureIdList"  type:"Repeated"`
	ProductKey    string    `position:"Query" name:"ProductKey"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
	DeviceName    string    `position:"Query" name:"DeviceName"`
}

// DeletePictureResponse is the response struct for api DeletePicture
type DeletePictureResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateDeletePictureRequest creates a request to invoke DeletePicture API
func CreateDeletePictureRequest() (request *DeletePictureRequest) {
	request = &DeletePictureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeletePicture", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletePictureResponse creates a response to parse from DeletePicture response
func CreateDeletePictureResponse() (response *DeletePictureResponse) {
	response = &DeletePictureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
