package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceCert invokes the iot.QueryDeviceCert API synchronously
func (client *Client) QueryDeviceCert(request *QueryDeviceCertRequest) (response *QueryDeviceCertResponse, err error) {
	response = CreateQueryDeviceCertResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceCertWithChan invokes the iot.QueryDeviceCert API asynchronously
func (client *Client) QueryDeviceCertWithChan(request *QueryDeviceCertRequest) (<-chan *QueryDeviceCertResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceCertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceCert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceCertWithCallback invokes the iot.QueryDeviceCert API asynchronously
func (client *Client) QueryDeviceCertWithCallback(request *QueryDeviceCertRequest, callback func(response *QueryDeviceCertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceCertResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceCert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceCertRequest is the request struct for api QueryDeviceCert
type QueryDeviceCertRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// QueryDeviceCertResponse is the response struct for api QueryDeviceCert
type QueryDeviceCertResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	ErrorMessage   string         `json:"ErrorMessage" xml:"ErrorMessage"`
	DeviceCertInfo DeviceCertInfo `json:"DeviceCertInfo" xml:"DeviceCertInfo"`
}

// CreateQueryDeviceCertRequest creates a request to invoke QueryDeviceCert API
func CreateQueryDeviceCertRequest() (request *QueryDeviceCertRequest) {
	request = &QueryDeviceCertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceCert", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceCertResponse creates a response to parse from QueryDeviceCert response
func CreateQueryDeviceCertResponse() (response *QueryDeviceCertResponse) {
	response = &QueryDeviceCertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
