package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserBasicInfos invokes the ims.ListUserBasicInfos API synchronously
func (client *Client) ListUserBasicInfos(request *ListUserBasicInfosRequest) (response *ListUserBasicInfosResponse, err error) {
	response = CreateListUserBasicInfosResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserBasicInfosWithChan invokes the ims.ListUserBasicInfos API asynchronously
func (client *Client) ListUserBasicInfosWithChan(request *ListUserBasicInfosRequest) (<-chan *ListUserBasicInfosResponse, <-chan error) {
	responseChan := make(chan *ListUserBasicInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserBasicInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserBasicInfosWithCallback invokes the ims.ListUserBasicInfos API asynchronously
func (client *Client) ListUserBasicInfosWithCallback(request *ListUserBasicInfosRequest, callback func(response *ListUserBasicInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserBasicInfosResponse
		var err error
		defer close(result)
		response, err = client.ListUserBasicInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserBasicInfosRequest is the request struct for api ListUserBasicInfos
type ListUserBasicInfosRequest struct {
	*requests.RpcRequest
	AkProxySuffix string                   `position:"Query" name:"AkProxySuffix"`
	Tag           *[]ListUserBasicInfosTag `position:"Query" name:"Tag"  type:"Repeated"`
	Marker        string                   `position:"Query" name:"Marker"`
	MaxItems      requests.Integer         `position:"Query" name:"MaxItems"`
	Status        string                   `position:"Query" name:"Status"`
}

// ListUserBasicInfosTag is a repeated param struct in ListUserBasicInfosRequest
type ListUserBasicInfosTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListUserBasicInfosResponse is the response struct for api ListUserBasicInfos
type ListUserBasicInfosResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	IsTruncated    bool           `json:"IsTruncated" xml:"IsTruncated"`
	Marker         string         `json:"Marker" xml:"Marker"`
	UserBasicInfos UserBasicInfos `json:"UserBasicInfos" xml:"UserBasicInfos"`
}

// CreateListUserBasicInfosRequest creates a request to invoke ListUserBasicInfos API
func CreateListUserBasicInfosRequest() (request *ListUserBasicInfosRequest) {
	request = &ListUserBasicInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "ListUserBasicInfos", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListUserBasicInfosResponse creates a response to parse from ListUserBasicInfos response
func CreateListUserBasicInfosResponse() (response *ListUserBasicInfosResponse) {
	response = &ListUserBasicInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
