package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssessExposure invokes the imageenhan.AssessExposure API synchronously
func (client *Client) AssessExposure(request *AssessExposureRequest) (response *AssessExposureResponse, err error) {
	response = CreateAssessExposureResponse()
	err = client.DoAction(request, response)
	return
}

// AssessExposureWithChan invokes the imageenhan.AssessExposure API asynchronously
func (client *Client) AssessExposureWithChan(request *AssessExposureRequest) (<-chan *AssessExposureResponse, <-chan error) {
	responseChan := make(chan *AssessExposureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssessExposure(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssessExposureWithCallback invokes the imageenhan.AssessExposure API asynchronously
func (client *Client) AssessExposureWithCallback(request *AssessExposureRequest, callback func(response *AssessExposureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssessExposureResponse
		var err error
		defer close(result)
		response, err = client.AssessExposure(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssessExposureRequest is the request struct for api AssessExposure
type AssessExposureRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// AssessExposureResponse is the response struct for api AssessExposure
type AssessExposureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAssessExposureRequest creates a request to invoke AssessExposure API
func CreateAssessExposureRequest() (request *AssessExposureRequest) {
	request = &AssessExposureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "AssessExposure", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssessExposureResponse creates a response to parse from AssessExposure response
func CreateAssessExposureResponse() (response *AssessExposureResponse) {
	response = &AssessExposureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
