package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceSecurityGroups invokes the hitsdb.GetInstanceSecurityGroups API synchronously
func (client *Client) GetInstanceSecurityGroups(request *GetInstanceSecurityGroupsRequest) (response *GetInstanceSecurityGroupsResponse, err error) {
	response = CreateGetInstanceSecurityGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceSecurityGroupsWithChan invokes the hitsdb.GetInstanceSecurityGroups API asynchronously
func (client *Client) GetInstanceSecurityGroupsWithChan(request *GetInstanceSecurityGroupsRequest) (<-chan *GetInstanceSecurityGroupsResponse, <-chan error) {
	responseChan := make(chan *GetInstanceSecurityGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceSecurityGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceSecurityGroupsWithCallback invokes the hitsdb.GetInstanceSecurityGroups API asynchronously
func (client *Client) GetInstanceSecurityGroupsWithCallback(request *GetInstanceSecurityGroupsRequest, callback func(response *GetInstanceSecurityGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceSecurityGroupsResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceSecurityGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceSecurityGroupsRequest is the request struct for api GetInstanceSecurityGroups
type GetInstanceSecurityGroupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// GetInstanceSecurityGroupsResponse is the response struct for api GetInstanceSecurityGroups
type GetInstanceSecurityGroupsResponse struct {
	*responses.BaseResponse
	InstanceId     string   `json:"InstanceId" xml:"InstanceId"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	SecurityGroups []string `json:"SecurityGroups" xml:"SecurityGroups"`
}

// CreateGetInstanceSecurityGroupsRequest creates a request to invoke GetInstanceSecurityGroups API
func CreateGetInstanceSecurityGroupsRequest() (request *GetInstanceSecurityGroupsRequest) {
	request = &GetInstanceSecurityGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "GetInstanceSecurityGroups", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceSecurityGroupsResponse creates a response to parse from GetInstanceSecurityGroups response
func CreateGetInstanceSecurityGroupsResponse() (response *GetInstanceSecurityGroupsResponse) {
	response = &GetInstanceSecurityGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
