package geoip

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGeoipInstanceDataInfos invokes the geoip.DescribeGeoipInstanceDataInfos API synchronously
func (client *Client) DescribeGeoipInstanceDataInfos(request *DescribeGeoipInstanceDataInfosRequest) (response *DescribeGeoipInstanceDataInfosResponse, err error) {
	response = CreateDescribeGeoipInstanceDataInfosResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGeoipInstanceDataInfosWithChan invokes the geoip.DescribeGeoipInstanceDataInfos API asynchronously
func (client *Client) DescribeGeoipInstanceDataInfosWithChan(request *DescribeGeoipInstanceDataInfosRequest) (<-chan *DescribeGeoipInstanceDataInfosResponse, <-chan error) {
	responseChan := make(chan *DescribeGeoipInstanceDataInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGeoipInstanceDataInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGeoipInstanceDataInfosWithCallback invokes the geoip.DescribeGeoipInstanceDataInfos API asynchronously
func (client *Client) DescribeGeoipInstanceDataInfosWithCallback(request *DescribeGeoipInstanceDataInfosRequest, callback func(response *DescribeGeoipInstanceDataInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGeoipInstanceDataInfosResponse
		var err error
		defer close(result)
		response, err = client.DescribeGeoipInstanceDataInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGeoipInstanceDataInfosRequest is the request struct for api DescribeGeoipInstanceDataInfos
type DescribeGeoipInstanceDataInfosRequest struct {
	*requests.RpcRequest
	LocationDataType string `position:"Query" name:"LocationDataType"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	UserClientIp     string `position:"Query" name:"UserClientIp"`
	Lang             string `position:"Query" name:"Lang"`
}

// DescribeGeoipInstanceDataInfosResponse is the response struct for api DescribeGeoipInstanceDataInfos
type DescribeGeoipInstanceDataInfosResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	DataInfos DataInfos `json:"DataInfos" xml:"DataInfos"`
}

// CreateDescribeGeoipInstanceDataInfosRequest creates a request to invoke DescribeGeoipInstanceDataInfos API
func CreateDescribeGeoipInstanceDataInfosRequest() (request *DescribeGeoipInstanceDataInfosRequest) {
	request = &DescribeGeoipInstanceDataInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("geoip", "2020-01-01", "DescribeGeoipInstanceDataInfos", "geoip", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGeoipInstanceDataInfosResponse creates a response to parse from DescribeGeoipInstanceDataInfos response
func CreateDescribeGeoipInstanceDataInfosResponse() (response *DescribeGeoipInstanceDataInfosResponse) {
	response = &DescribeGeoipInstanceDataInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
