package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceChargeType invokes the ens.ModifyInstanceChargeType API synchronously
func (client *Client) ModifyInstanceChargeType(request *ModifyInstanceChargeTypeRequest) (response *ModifyInstanceChargeTypeResponse, err error) {
	response = CreateModifyInstanceChargeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceChargeTypeWithChan invokes the ens.ModifyInstanceChargeType API asynchronously
func (client *Client) ModifyInstanceChargeTypeWithChan(request *ModifyInstanceChargeTypeRequest) (<-chan *ModifyInstanceChargeTypeResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceChargeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceChargeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceChargeTypeWithCallback invokes the ens.ModifyInstanceChargeType API asynchronously
func (client *Client) ModifyInstanceChargeTypeWithCallback(request *ModifyInstanceChargeTypeRequest, callback func(response *ModifyInstanceChargeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceChargeTypeResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceChargeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceChargeTypeRequest is the request struct for api ModifyInstanceChargeType
type ModifyInstanceChargeTypeRequest struct {
	*requests.RpcRequest
	Period             string           `position:"Query" name:"Period"`
	IncludeDataDisks   requests.Boolean `position:"Query" name:"IncludeDataDisks"`
	PeriodUnit         string           `position:"Query" name:"PeriodUnit"`
	AutoRenew          requests.Boolean `position:"Query" name:"AutoRenew"`
	InstanceIds        *[]string        `position:"Query" name:"InstanceIds"  type:"Json"`
	InstanceChargeType string           `position:"Query" name:"InstanceChargeType"`
	AutoPay            requests.Boolean `position:"Query" name:"AutoPay"`
}

// ModifyInstanceChargeTypeResponse is the response struct for api ModifyInstanceChargeType
type ModifyInstanceChargeTypeResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	OrderId     int64    `json:"OrderId" xml:"OrderId"`
	InstanceIds []string `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateModifyInstanceChargeTypeRequest creates a request to invoke ModifyInstanceChargeType API
func CreateModifyInstanceChargeTypeRequest() (request *ModifyInstanceChargeTypeRequest) {
	request = &ModifyInstanceChargeTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ModifyInstanceChargeType", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceChargeTypeResponse creates a response to parse from ModifyInstanceChargeType response
func CreateModifyInstanceChargeTypeResponse() (response *ModifyInstanceChargeTypeResponse) {
	response = &ModifyInstanceChargeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
