package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSDGDeploymentStatus invokes the ens.DescribeSDGDeploymentStatus API synchronously
func (client *Client) DescribeSDGDeploymentStatus(request *DescribeSDGDeploymentStatusRequest) (response *DescribeSDGDeploymentStatusResponse, err error) {
	response = CreateDescribeSDGDeploymentStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSDGDeploymentStatusWithChan invokes the ens.DescribeSDGDeploymentStatus API asynchronously
func (client *Client) DescribeSDGDeploymentStatusWithChan(request *DescribeSDGDeploymentStatusRequest) (<-chan *DescribeSDGDeploymentStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeSDGDeploymentStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSDGDeploymentStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSDGDeploymentStatusWithCallback invokes the ens.DescribeSDGDeploymentStatus API asynchronously
func (client *Client) DescribeSDGDeploymentStatusWithCallback(request *DescribeSDGDeploymentStatusRequest, callback func(response *DescribeSDGDeploymentStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSDGDeploymentStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeSDGDeploymentStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSDGDeploymentStatusRequest is the request struct for api DescribeSDGDeploymentStatus
type DescribeSDGDeploymentStatusRequest struct {
	*requests.RpcRequest
	RegionIds      *[]string        `position:"Query" name:"RegionIds"  type:"Json"`
	InstanceIds    *[]string        `position:"Query" name:"InstanceIds"  type:"Json"`
	Status         string           `position:"Query" name:"Status"`
	DeploymentType string           `position:"Query" name:"DeploymentType"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	SDGId          string           `position:"Query" name:"SDGId"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeSDGDeploymentStatusResponse is the response struct for api DescribeSDGDeploymentStatus
type DescribeSDGDeploymentStatusResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	PageNumber       int64                  `json:"PageNumber" xml:"PageNumber"`
	PageSize         int64                  `json:"PageSize" xml:"PageSize"`
	TotalCount       int64                  `json:"TotalCount" xml:"TotalCount"`
	DeploymentStatus []DeploymentStatusItem `json:"DeploymentStatus" xml:"DeploymentStatus"`
}

// CreateDescribeSDGDeploymentStatusRequest creates a request to invoke DescribeSDGDeploymentStatus API
func CreateDescribeSDGDeploymentStatusRequest() (request *DescribeSDGDeploymentStatusRequest) {
	request = &DescribeSDGDeploymentStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeSDGDeploymentStatus", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSDGDeploymentStatusResponse creates a response to parse from DescribeSDGDeploymentStatus response
func CreateDescribeSDGDeploymentStatusResponse() (response *DescribeSDGDeploymentStatusResponse) {
	response = &DescribeSDGDeploymentStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
