package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSDG invokes the ens.DescribeSDG API synchronously
func (client *Client) DescribeSDG(request *DescribeSDGRequest) (response *DescribeSDGResponse, err error) {
	response = CreateDescribeSDGResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSDGWithChan invokes the ens.DescribeSDG API asynchronously
func (client *Client) DescribeSDGWithChan(request *DescribeSDGRequest) (<-chan *DescribeSDGResponse, <-chan error) {
	responseChan := make(chan *DescribeSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSDGWithCallback invokes the ens.DescribeSDG API asynchronously
func (client *Client) DescribeSDGWithCallback(request *DescribeSDGRequest, callback func(response *DescribeSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSDGResponse
		var err error
		defer close(result)
		response, err = client.DescribeSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSDGRequest is the request struct for api DescribeSDG
type DescribeSDGRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	SDGIds     *[]string        `position:"Query" name:"SDGIds"  type:"Json"`
}

// DescribeSDGResponse is the response struct for api DescribeSDG
type DescribeSDGResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	SDGs       []SDGsItem `json:"SDGs" xml:"SDGs"`
}

// CreateDescribeSDGRequest creates a request to invoke DescribeSDG API
func CreateDescribeSDGRequest() (request *DescribeSDGRequest) {
	request = &DescribeSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSDGResponse creates a response to parse from DescribeSDG response
func CreateDescribeSDGResponse() (response *DescribeSDGResponse) {
	response = &DescribeSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
