package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEmrMainVersion invokes the emr.ListEmrMainVersion API synchronously
func (client *Client) ListEmrMainVersion(request *ListEmrMainVersionRequest) (response *ListEmrMainVersionResponse, err error) {
	response = CreateListEmrMainVersionResponse()
	err = client.DoAction(request, response)
	return
}

// ListEmrMainVersionWithChan invokes the emr.ListEmrMainVersion API asynchronously
func (client *Client) ListEmrMainVersionWithChan(request *ListEmrMainVersionRequest) (<-chan *ListEmrMainVersionResponse, <-chan error) {
	responseChan := make(chan *ListEmrMainVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEmrMainVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEmrMainVersionWithCallback invokes the emr.ListEmrMainVersion API asynchronously
func (client *Client) ListEmrMainVersionWithCallback(request *ListEmrMainVersionRequest, callback func(response *ListEmrMainVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEmrMainVersionResponse
		var err error
		defer close(result)
		response, err = client.ListEmrMainVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEmrMainVersionRequest is the request struct for api ListEmrMainVersion
type ListEmrMainVersionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	EmrVersion      string           `position:"Query" name:"EmrVersion"`
	StackName       string           `position:"Query" name:"StackName"`
	StackVersion    string           `position:"Query" name:"StackVersion"`
}

// ListEmrMainVersionResponse is the response struct for api ListEmrMainVersion
type ListEmrMainVersionResponse struct {
	*responses.BaseResponse
	RequestId          string                                 `json:"RequestId" xml:"RequestId"`
	TotalCount         int                                    `json:"TotalCount" xml:"TotalCount"`
	PageNumber         int                                    `json:"PageNumber" xml:"PageNumber"`
	PageSize           int                                    `json:"PageSize" xml:"PageSize"`
	EmrMainVersionList EmrMainVersionListInListEmrMainVersion `json:"EmrMainVersionList" xml:"EmrMainVersionList"`
}

// CreateListEmrMainVersionRequest creates a request to invoke ListEmrMainVersion API
func CreateListEmrMainVersionRequest() (request *ListEmrMainVersionRequest) {
	request = &ListEmrMainVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListEmrMainVersion", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEmrMainVersionResponse creates a response to parse from ListEmrMainVersion response
func CreateListEmrMainVersionResponse() (response *ListEmrMainVersionResponse) {
	response = &ListEmrMainVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
