package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PostEmonTryAlarmRule invokes the elasticsearch.PostEmonTryAlarmRule API synchronously
func (client *Client) PostEmonTryAlarmRule(request *PostEmonTryAlarmRuleRequest) (response *PostEmonTryAlarmRuleResponse, err error) {
	response = CreatePostEmonTryAlarmRuleResponse()
	err = client.DoAction(request, response)
	return
}

// PostEmonTryAlarmRuleWithChan invokes the elasticsearch.PostEmonTryAlarmRule API asynchronously
func (client *Client) PostEmonTryAlarmRuleWithChan(request *PostEmonTryAlarmRuleRequest) (<-chan *PostEmonTryAlarmRuleResponse, <-chan error) {
	responseChan := make(chan *PostEmonTryAlarmRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PostEmonTryAlarmRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PostEmonTryAlarmRuleWithCallback invokes the elasticsearch.PostEmonTryAlarmRule API asynchronously
func (client *Client) PostEmonTryAlarmRuleWithCallback(request *PostEmonTryAlarmRuleRequest, callback func(response *PostEmonTryAlarmRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PostEmonTryAlarmRuleResponse
		var err error
		defer close(result)
		response, err = client.PostEmonTryAlarmRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PostEmonTryAlarmRuleRequest is the request struct for api PostEmonTryAlarmRule
type PostEmonTryAlarmRuleRequest struct {
	*requests.RoaRequest
	AlarmGroupId string `position:"Path" name:"AlarmGroupId"`
	Body         string `position:"Body" name:"body"`
	ProjectId    string `position:"Path" name:"ProjectId"`
}

// PostEmonTryAlarmRuleResponse is the response struct for api PostEmonTryAlarmRule
type PostEmonTryAlarmRuleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreatePostEmonTryAlarmRuleRequest creates a request to invoke PostEmonTryAlarmRule API
func CreatePostEmonTryAlarmRuleRequest() (request *PostEmonTryAlarmRuleRequest) {
	request = &PostEmonTryAlarmRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "PostEmonTryAlarmRule", "/openapi/emon/projects/[ProjectId]/alarm-groups/[AlarmGroupId]/alarm-rules/_test", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePostEmonTryAlarmRuleResponse creates a response to parse from PostEmonTryAlarmRule response
func CreatePostEmonTryAlarmRuleResponse() (response *PostEmonTryAlarmRuleResponse) {
	response = &PostEmonTryAlarmRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
