package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAckClusters invokes the elasticsearch.ListAckClusters API synchronously
func (client *Client) ListAckClusters(request *ListAckClustersRequest) (response *ListAckClustersResponse, err error) {
	response = CreateListAckClustersResponse()
	err = client.DoAction(request, response)
	return
}

// ListAckClustersWithChan invokes the elasticsearch.ListAckClusters API asynchronously
func (client *Client) ListAckClustersWithChan(request *ListAckClustersRequest) (<-chan *ListAckClustersResponse, <-chan error) {
	responseChan := make(chan *ListAckClustersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAckClusters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAckClustersWithCallback invokes the elasticsearch.ListAckClusters API asynchronously
func (client *Client) ListAckClustersWithCallback(request *ListAckClustersRequest, callback func(response *ListAckClustersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAckClustersResponse
		var err error
		defer close(result)
		response, err = client.ListAckClusters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAckClustersRequest is the request struct for api ListAckClusters
type ListAckClustersRequest struct {
	*requests.RoaRequest
	Size  requests.Integer `position:"Query" name:"size"`
	VpcId string           `position:"Query" name:"vpcId"`
	Page  requests.Integer `position:"Query" name:"page"`
}

// ListAckClustersResponse is the response struct for api ListAckClusters
type ListAckClustersResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListAckClustersRequest creates a request to invoke ListAckClusters API
func CreateListAckClustersRequest() (request *ListAckClustersRequest) {
	request = &ListAckClustersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListAckClusters", "/openapi/ack-clusters", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAckClustersResponse creates a response to parse from ListAckClusters response
func CreateListAckClustersResponse() (response *ListAckClustersResponse) {
	response = &ListAckClustersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
