package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListElasticNetworkInterfaces invokes the eflo.ListElasticNetworkInterfaces API synchronously
func (client *Client) ListElasticNetworkInterfaces(request *ListElasticNetworkInterfacesRequest) (response *ListElasticNetworkInterfacesResponse, err error) {
	response = CreateListElasticNetworkInterfacesResponse()
	err = client.DoAction(request, response)
	return
}

// ListElasticNetworkInterfacesWithChan invokes the eflo.ListElasticNetworkInterfaces API asynchronously
func (client *Client) ListElasticNetworkInterfacesWithChan(request *ListElasticNetworkInterfacesRequest) (<-chan *ListElasticNetworkInterfacesResponse, <-chan error) {
	responseChan := make(chan *ListElasticNetworkInterfacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListElasticNetworkInterfaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListElasticNetworkInterfacesWithCallback invokes the eflo.ListElasticNetworkInterfaces API asynchronously
func (client *Client) ListElasticNetworkInterfacesWithCallback(request *ListElasticNetworkInterfacesRequest, callback func(response *ListElasticNetworkInterfacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListElasticNetworkInterfacesResponse
		var err error
		defer close(result)
		response, err = client.ListElasticNetworkInterfaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListElasticNetworkInterfacesRequest is the request struct for api ListElasticNetworkInterfaces
type ListElasticNetworkInterfacesRequest struct {
	*requests.RpcRequest
	NetworkType               string           `position:"Body" name:"NetworkType"`
	Type                      string           `position:"Body" name:"Type"`
	PageNumber                requests.Integer `position:"Body" name:"PageNumber"`
	PageSize                  requests.Integer `position:"Body" name:"PageSize"`
	NodeId                    string           `position:"Body" name:"NodeId"`
	Ip                        string           `position:"Body" name:"Ip"`
	VSwitchId                 string           `position:"Body" name:"VSwitchId"`
	VpcId                     string           `position:"Body" name:"VpcId"`
	ZoneId                    string           `position:"Body" name:"ZoneId"`
	ElasticNetworkInterfaceId string           `position:"Body" name:"ElasticNetworkInterfaceId"`
	Status                    string           `position:"Body" name:"Status"`
}

// ListElasticNetworkInterfacesResponse is the response struct for api ListElasticNetworkInterfaces
type ListElasticNetworkInterfacesResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListElasticNetworkInterfacesRequest creates a request to invoke ListElasticNetworkInterfaces API
func CreateListElasticNetworkInterfacesRequest() (request *ListElasticNetworkInterfacesRequest) {
	request = &ListElasticNetworkInterfacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListElasticNetworkInterfaces", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListElasticNetworkInterfacesResponse creates a response to parse from ListElasticNetworkInterfaces response
func CreateListElasticNetworkInterfacesResponse() (response *ListElasticNetworkInterfacesResponse) {
	response = &ListElasticNetworkInterfacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
