package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSwimmingLaneGroup invokes the edas.UpdateSwimmingLaneGroup API synchronously
func (client *Client) UpdateSwimmingLaneGroup(request *UpdateSwimmingLaneGroupRequest) (response *UpdateSwimmingLaneGroupResponse, err error) {
	response = CreateUpdateSwimmingLaneGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSwimmingLaneGroupWithChan invokes the edas.UpdateSwimmingLaneGroup API asynchronously
func (client *Client) UpdateSwimmingLaneGroupWithChan(request *UpdateSwimmingLaneGroupRequest) (<-chan *UpdateSwimmingLaneGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateSwimmingLaneGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSwimmingLaneGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSwimmingLaneGroupWithCallback invokes the edas.UpdateSwimmingLaneGroup API asynchronously
func (client *Client) UpdateSwimmingLaneGroupWithCallback(request *UpdateSwimmingLaneGroupRequest, callback func(response *UpdateSwimmingLaneGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSwimmingLaneGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateSwimmingLaneGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSwimmingLaneGroupRequest is the request struct for api UpdateSwimmingLaneGroup
type UpdateSwimmingLaneGroupRequest struct {
	*requests.RoaRequest
	AppIds   string           `position:"Query" name:"AppIds"`
	GroupId  requests.Integer `position:"Query" name:"GroupId"`
	Name     string           `position:"Query" name:"Name"`
	EntryApp string           `position:"Query" name:"EntryApp"`
}

// UpdateSwimmingLaneGroupResponse is the response struct for api UpdateSwimmingLaneGroup
type UpdateSwimmingLaneGroupResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateSwimmingLaneGroupRequest creates a request to invoke UpdateSwimmingLaneGroup API
func CreateUpdateSwimmingLaneGroupRequest() (request *UpdateSwimmingLaneGroupRequest) {
	request = &UpdateSwimmingLaneGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateSwimmingLaneGroup", "/pop/v5/trafficmgnt/swimming_lane_groups", "Edas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateSwimmingLaneGroupResponse creates a response to parse from UpdateSwimmingLaneGroup response
func CreateUpdateSwimmingLaneGroupResponse() (response *UpdateSwimmingLaneGroupResponse) {
	response = &UpdateSwimmingLaneGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
