package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOfficeSiteSsoStatus invokes the ecd.GetOfficeSiteSsoStatus API synchronously
func (client *Client) GetOfficeSiteSsoStatus(request *GetOfficeSiteSsoStatusRequest) (response *GetOfficeSiteSsoStatusResponse, err error) {
	response = CreateGetOfficeSiteSsoStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetOfficeSiteSsoStatusWithChan invokes the ecd.GetOfficeSiteSsoStatus API asynchronously
func (client *Client) GetOfficeSiteSsoStatusWithChan(request *GetOfficeSiteSsoStatusRequest) (<-chan *GetOfficeSiteSsoStatusResponse, <-chan error) {
	responseChan := make(chan *GetOfficeSiteSsoStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOfficeSiteSsoStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOfficeSiteSsoStatusWithCallback invokes the ecd.GetOfficeSiteSsoStatus API asynchronously
func (client *Client) GetOfficeSiteSsoStatusWithCallback(request *GetOfficeSiteSsoStatusRequest, callback func(response *GetOfficeSiteSsoStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOfficeSiteSsoStatusResponse
		var err error
		defer close(result)
		response, err = client.GetOfficeSiteSsoStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOfficeSiteSsoStatusRequest is the request struct for api GetOfficeSiteSsoStatus
type GetOfficeSiteSsoStatusRequest struct {
	*requests.RpcRequest
	OfficeSiteId string `position:"Query" name:"OfficeSiteId"`
}

// GetOfficeSiteSsoStatusResponse is the response struct for api GetOfficeSiteSsoStatus
type GetOfficeSiteSsoStatusResponse struct {
	*responses.BaseResponse
	SsoStatus bool   `json:"SsoStatus" xml:"SsoStatus"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetOfficeSiteSsoStatusRequest creates a request to invoke GetOfficeSiteSsoStatus API
func CreateGetOfficeSiteSsoStatusRequest() (request *GetOfficeSiteSsoStatusRequest) {
	request = &GetOfficeSiteSsoStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "GetOfficeSiteSsoStatus", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetOfficeSiteSsoStatusResponse creates a response to parse from GetOfficeSiteSsoStatus response
func CreateGetOfficeSiteSsoStatusResponse() (response *GetOfficeSiteSsoStatusResponse) {
	response = &GetOfficeSiteSsoStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
