package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGuestApplications invokes the ecd.DescribeGuestApplications API synchronously
func (client *Client) DescribeGuestApplications(request *DescribeGuestApplicationsRequest) (response *DescribeGuestApplicationsResponse, err error) {
	response = CreateDescribeGuestApplicationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGuestApplicationsWithChan invokes the ecd.DescribeGuestApplications API asynchronously
func (client *Client) DescribeGuestApplicationsWithChan(request *DescribeGuestApplicationsRequest) (<-chan *DescribeGuestApplicationsResponse, <-chan error) {
	responseChan := make(chan *DescribeGuestApplicationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGuestApplications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGuestApplicationsWithCallback invokes the ecd.DescribeGuestApplications API asynchronously
func (client *Client) DescribeGuestApplicationsWithCallback(request *DescribeGuestApplicationsRequest, callback func(response *DescribeGuestApplicationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGuestApplicationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGuestApplications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGuestApplicationsRequest is the request struct for api DescribeGuestApplications
type DescribeGuestApplicationsRequest struct {
	*requests.RpcRequest
	EndUserId string `position:"Query" name:"EndUserId"`
	DesktopId string `position:"Query" name:"DesktopId"`
}

// DescribeGuestApplicationsResponse is the response struct for api DescribeGuestApplications
type DescribeGuestApplicationsResponse struct {
	*responses.BaseResponse
	RequestId    string                  `json:"RequestId" xml:"RequestId"`
	Applications []GuestApplicationModel `json:"Applications" xml:"Applications"`
}

// CreateDescribeGuestApplicationsRequest creates a request to invoke DescribeGuestApplications API
func CreateDescribeGuestApplicationsRequest() (request *DescribeGuestApplicationsRequest) {
	request = &DescribeGuestApplicationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeGuestApplications", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGuestApplicationsResponse creates a response to parse from DescribeGuestApplications response
func CreateDescribeGuestApplicationsResponse() (response *DescribeGuestApplicationsResponse) {
	response = &DescribeGuestApplicationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
