package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFilePermission invokes the ecd.AddFilePermission API synchronously
func (client *Client) AddFilePermission(request *AddFilePermissionRequest) (response *AddFilePermissionResponse, err error) {
	response = CreateAddFilePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// AddFilePermissionWithChan invokes the ecd.AddFilePermission API asynchronously
func (client *Client) AddFilePermissionWithChan(request *AddFilePermissionRequest) (<-chan *AddFilePermissionResponse, <-chan error) {
	responseChan := make(chan *AddFilePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFilePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFilePermissionWithCallback invokes the ecd.AddFilePermission API asynchronously
func (client *Client) AddFilePermissionWithCallback(request *AddFilePermissionRequest, callback func(response *AddFilePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFilePermissionResponse
		var err error
		defer close(result)
		response, err = client.AddFilePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFilePermissionRequest is the request struct for api AddFilePermission
type AddFilePermissionRequest struct {
	*requests.RpcRequest
	MemberList *[]AddFilePermissionMemberList `position:"Query" name:"MemberList"  type:"Json"`
	GroupId    string                         `position:"Query" name:"GroupId"`
	CdsId      string                         `position:"Query" name:"CdsId"`
	EndUserId  string                         `position:"Query" name:"EndUserId"`
	FileId     string                         `position:"Query" name:"FileId"`
}

// AddFilePermissionMemberList is a repeated param struct in AddFilePermissionRequest
type AddFilePermissionMemberList struct {
	ExpireTime         string                                 `name:"ExpireTime"`
	RoleId             string                                 `name:"RoleId"`
	CdsIdentity        AddFilePermissionMemberListCdsIdentity `name:"CdsIdentity" type:"Struct"`
	DisinheritSubGroup string                                 `name:"DisinheritSubGroup"`
}

// AddFilePermissionMemberListCdsIdentity is a repeated param struct in AddFilePermissionRequest
type AddFilePermissionMemberListCdsIdentity struct {
	Id   string `name:"Id"`
	Type string `name:"Type"`
}

// AddFilePermissionResponse is the response struct for api AddFilePermission
type AddFilePermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddFilePermissionRequest creates a request to invoke AddFilePermission API
func CreateAddFilePermissionRequest() (request *AddFilePermissionRequest) {
	request = &AddFilePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "AddFilePermission", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFilePermissionResponse creates a response to parse from AddFilePermission response
func CreateAddFilePermissionResponse() (response *AddFilePermissionResponse) {
	response = &AddFilePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
