package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFusionAuthToken invokes the dypnsapi.GetFusionAuthToken API synchronously
func (client *Client) GetFusionAuthToken(request *GetFusionAuthTokenRequest) (response *GetFusionAuthTokenResponse, err error) {
	response = CreateGetFusionAuthTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetFusionAuthTokenWithChan invokes the dypnsapi.GetFusionAuthToken API asynchronously
func (client *Client) GetFusionAuthTokenWithChan(request *GetFusionAuthTokenRequest) (<-chan *GetFusionAuthTokenResponse, <-chan error) {
	responseChan := make(chan *GetFusionAuthTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFusionAuthToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFusionAuthTokenWithCallback invokes the dypnsapi.GetFusionAuthToken API asynchronously
func (client *Client) GetFusionAuthTokenWithCallback(request *GetFusionAuthTokenRequest, callback func(response *GetFusionAuthTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFusionAuthTokenResponse
		var err error
		defer close(result)
		response, err = client.GetFusionAuthToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFusionAuthTokenRequest is the request struct for api GetFusionAuthToken
type GetFusionAuthTokenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BundleId             string           `position:"Query" name:"BundleId"`
	Platform             string           `position:"Query" name:"Platform"`
	SchemeCode           string           `position:"Query" name:"SchemeCode"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PackageName          string           `position:"Query" name:"PackageName"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PackageSign          string           `position:"Query" name:"PackageSign"`
	DurationSeconds      requests.Integer `position:"Query" name:"DurationSeconds"`
}

// GetFusionAuthTokenResponse is the response struct for api GetFusionAuthToken
type GetFusionAuthTokenResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     string `json:"Model" xml:"Model"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetFusionAuthTokenRequest creates a request to invoke GetFusionAuthToken API
func CreateGetFusionAuthTokenRequest() (request *GetFusionAuthTokenRequest) {
	request = &GetFusionAuthTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "GetFusionAuthToken", "dypnsapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetFusionAuthTokenResponse creates a response to parse from GetFusionAuthToken response
func CreateGetFusionAuthTokenResponse() (response *GetFusionAuthTokenResponse) {
	response = &GetFusionAuthTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
