package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreviewWorkflow invokes the dms_enterprise.PreviewWorkflow API synchronously
func (client *Client) PreviewWorkflow(request *PreviewWorkflowRequest) (response *PreviewWorkflowResponse, err error) {
	response = CreatePreviewWorkflowResponse()
	err = client.DoAction(request, response)
	return
}

// PreviewWorkflowWithChan invokes the dms_enterprise.PreviewWorkflow API asynchronously
func (client *Client) PreviewWorkflowWithChan(request *PreviewWorkflowRequest) (<-chan *PreviewWorkflowResponse, <-chan error) {
	responseChan := make(chan *PreviewWorkflowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreviewWorkflow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreviewWorkflowWithCallback invokes the dms_enterprise.PreviewWorkflow API asynchronously
func (client *Client) PreviewWorkflowWithCallback(request *PreviewWorkflowRequest, callback func(response *PreviewWorkflowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreviewWorkflowResponse
		var err error
		defer close(result)
		response, err = client.PreviewWorkflow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreviewWorkflowRequest is the request struct for api PreviewWorkflow
type PreviewWorkflowRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// PreviewWorkflowResponse is the response struct for api PreviewWorkflow
type PreviewWorkflowResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ErrorCode      string         `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string         `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool           `json:"Success" xml:"Success"`
	WorkflowDetail WorkflowDetail `json:"WorkflowDetail" xml:"WorkflowDetail"`
}

// CreatePreviewWorkflowRequest creates a request to invoke PreviewWorkflow API
func CreatePreviewWorkflowRequest() (request *PreviewWorkflowRequest) {
	request = &PreviewWorkflowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "PreviewWorkflow", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePreviewWorkflowResponse creates a response to parse from PreviewWorkflow response
func CreatePreviewWorkflowResponse() (response *PreviewWorkflowResponse) {
	response = &PreviewWorkflowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
