package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProxyAccesses invokes the dms_enterprise.ListProxyAccesses API synchronously
func (client *Client) ListProxyAccesses(request *ListProxyAccessesRequest) (response *ListProxyAccessesResponse, err error) {
	response = CreateListProxyAccessesResponse()
	err = client.DoAction(request, response)
	return
}

// ListProxyAccessesWithChan invokes the dms_enterprise.ListProxyAccesses API asynchronously
func (client *Client) ListProxyAccessesWithChan(request *ListProxyAccessesRequest) (<-chan *ListProxyAccessesResponse, <-chan error) {
	responseChan := make(chan *ListProxyAccessesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProxyAccesses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProxyAccessesWithCallback invokes the dms_enterprise.ListProxyAccesses API asynchronously
func (client *Client) ListProxyAccessesWithCallback(request *ListProxyAccessesRequest, callback func(response *ListProxyAccessesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProxyAccessesResponse
		var err error
		defer close(result)
		response, err = client.ListProxyAccesses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProxyAccessesRequest is the request struct for api ListProxyAccesses
type ListProxyAccessesRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	ProxyId requests.Integer `position:"Query" name:"ProxyId"`
}

// ListProxyAccessesResponse is the response struct for api ListProxyAccesses
type ListProxyAccessesResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	Success         bool                  `json:"Success" xml:"Success"`
	ErrorMessage    string                `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode       string                `json:"ErrorCode" xml:"ErrorCode"`
	ProxyAccessList []ProxyAccessListItem `json:"ProxyAccessList" xml:"ProxyAccessList"`
}

// CreateListProxyAccessesRequest creates a request to invoke ListProxyAccesses API
func CreateListProxyAccessesRequest() (request *ListProxyAccessesRequest) {
	request = &ListProxyAccessesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListProxyAccesses", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListProxyAccessesResponse creates a response to parse from ListProxyAccesses response
func CreateListProxyAccessesResponse() (response *ListProxyAccessesResponse) {
	response = &ListProxyAccessesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
