package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryReceiverDetail invokes the dm.QueryReceiverDetail API synchronously
// api document: https://help.aliyun.com/api/dm/queryreceiverdetail.html
func (client *Client) QueryReceiverDetail(request *QueryReceiverDetailRequest) (response *QueryReceiverDetailResponse, err error) {
	response = CreateQueryReceiverDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryReceiverDetailWithChan invokes the dm.QueryReceiverDetail API asynchronously
// api document: https://help.aliyun.com/api/dm/queryreceiverdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryReceiverDetailWithChan(request *QueryReceiverDetailRequest) (<-chan *QueryReceiverDetailResponse, <-chan error) {
	responseChan := make(chan *QueryReceiverDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryReceiverDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryReceiverDetailWithCallback invokes the dm.QueryReceiverDetail API asynchronously
// api document: https://help.aliyun.com/api/dm/queryreceiverdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryReceiverDetailWithCallback(request *QueryReceiverDetailRequest, callback func(response *QueryReceiverDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryReceiverDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryReceiverDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryReceiverDetailRequest is the request struct for api QueryReceiverDetail
type QueryReceiverDetailRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReceiverId           string           `position:"Query" name:"ReceiverId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	KeyWord              string           `position:"Query" name:"KeyWord"`
	NextStart            string           `position:"Query" name:"NextStart"`
}

// QueryReceiverDetailResponse is the response struct for api QueryReceiverDetail
type QueryReceiverDetailResponse struct {
	*responses.BaseResponse
	RequestId  string                    `json:"RequestId" xml:"RequestId"`
	TotalCount int                       `json:"TotalCount" xml:"TotalCount"`
	NextStart  string                    `json:"NextStart" xml:"NextStart"`
	DataSchema string                    `json:"DataSchema" xml:"DataSchema"`
	Data       DataInQueryReceiverDetail `json:"data" xml:"data"`
}

// CreateQueryReceiverDetailRequest creates a request to invoke QueryReceiverDetail API
func CreateQueryReceiverDetailRequest() (request *QueryReceiverDetailRequest) {
	request = &QueryReceiverDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "QueryReceiverDetail", "", "")
	return
}

// CreateQueryReceiverDetailResponse creates a response to parse from QueryReceiverDetail response
func CreateQueryReceiverDetailResponse() (response *QueryReceiverDetailResponse) {
	response = &QueryReceiverDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
