package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserGroupsMapping invokes the dfs.CreateUserGroupsMapping API synchronously
func (client *Client) CreateUserGroupsMapping(request *CreateUserGroupsMappingRequest) (response *CreateUserGroupsMappingResponse, err error) {
	response = CreateCreateUserGroupsMappingResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserGroupsMappingWithChan invokes the dfs.CreateUserGroupsMapping API asynchronously
func (client *Client) CreateUserGroupsMappingWithChan(request *CreateUserGroupsMappingRequest) (<-chan *CreateUserGroupsMappingResponse, <-chan error) {
	responseChan := make(chan *CreateUserGroupsMappingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserGroupsMapping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserGroupsMappingWithCallback invokes the dfs.CreateUserGroupsMapping API asynchronously
func (client *Client) CreateUserGroupsMappingWithCallback(request *CreateUserGroupsMappingRequest, callback func(response *CreateUserGroupsMappingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserGroupsMappingResponse
		var err error
		defer close(result)
		response, err = client.CreateUserGroupsMapping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserGroupsMappingRequest is the request struct for api CreateUserGroupsMapping
type CreateUserGroupsMappingRequest struct {
	*requests.RpcRequest
	GroupNames    *[]string `position:"Query" name:"GroupNames"  type:"Json"`
	InputRegionId string    `position:"Query" name:"InputRegionId"`
	FileSystemId  string    `position:"Query" name:"FileSystemId"`
	UserName      string    `position:"Query" name:"UserName"`
}

// CreateUserGroupsMappingResponse is the response struct for api CreateUserGroupsMapping
type CreateUserGroupsMappingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateUserGroupsMappingRequest creates a request to invoke CreateUserGroupsMapping API
func CreateCreateUserGroupsMappingRequest() (request *CreateUserGroupsMappingRequest) {
	request = &CreateUserGroupsMappingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "CreateUserGroupsMapping", "alidfs", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCreateUserGroupsMappingResponse creates a response to parse from CreateUserGroupsMapping response
func CreateCreateUserGroupsMappingResponse() (response *CreateUserGroupsMappingResponse) {
	response = &CreateUserGroupsMappingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
