package ddosdiversion

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigNetStatus invokes the ddosdiversion.ConfigNetStatus API synchronously
func (client *Client) ConfigNetStatus(request *ConfigNetStatusRequest) (response *ConfigNetStatusResponse, err error) {
	response = CreateConfigNetStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigNetStatusWithChan invokes the ddosdiversion.ConfigNetStatus API asynchronously
func (client *Client) ConfigNetStatusWithChan(request *ConfigNetStatusRequest) (<-chan *ConfigNetStatusResponse, <-chan error) {
	responseChan := make(chan *ConfigNetStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigNetStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigNetStatusWithCallback invokes the ddosdiversion.ConfigNetStatus API asynchronously
func (client *Client) ConfigNetStatusWithCallback(request *ConfigNetStatusRequest, callback func(response *ConfigNetStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigNetStatusResponse
		var err error
		defer close(result)
		response, err = client.ConfigNetStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigNetStatusRequest is the request struct for api ConfigNetStatus
type ConfigNetStatusRequest struct {
	*requests.RpcRequest
	Regions *[]string `position:"Query" name:"Regions"  type:"Repeated"`
	SubNets *[]string `position:"Query" name:"SubNets"  type:"Repeated"`
	Net     string    `position:"Query" name:"Net"`
	SaleId  string    `position:"Query" name:"SaleId"`
	Status  string    `position:"Query" name:"Status"`
}

// ConfigNetStatusResponse is the response struct for api ConfigNetStatus
type ConfigNetStatusResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateConfigNetStatusRequest creates a request to invoke ConfigNetStatus API
func CreateConfigNetStatusRequest() (request *ConfigNetStatusRequest) {
	request = &ConfigNetStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DdosDiversion", "2023-07-01", "ConfigNetStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigNetStatusResponse creates a response to parse from ConfigNetStatus response
func CreateConfigNetStatusResponse() (response *ConfigNetStatusResponse) {
	response = &ConfigNetStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
