package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnSSLCertificateList invokes the dcdn.DescribeDcdnSSLCertificateList API synchronously
func (client *Client) DescribeDcdnSSLCertificateList(request *DescribeDcdnSSLCertificateListRequest) (response *DescribeDcdnSSLCertificateListResponse, err error) {
	response = CreateDescribeDcdnSSLCertificateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnSSLCertificateListWithChan invokes the dcdn.DescribeDcdnSSLCertificateList API asynchronously
func (client *Client) DescribeDcdnSSLCertificateListWithChan(request *DescribeDcdnSSLCertificateListRequest) (<-chan *DescribeDcdnSSLCertificateListResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnSSLCertificateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnSSLCertificateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnSSLCertificateListWithCallback invokes the dcdn.DescribeDcdnSSLCertificateList API asynchronously
func (client *Client) DescribeDcdnSSLCertificateListWithCallback(request *DescribeDcdnSSLCertificateListRequest, callback func(response *DescribeDcdnSSLCertificateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnSSLCertificateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnSSLCertificateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnSSLCertificateListRequest is the request struct for api DescribeDcdnSSLCertificateList
type DescribeDcdnSSLCertificateListRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	MatchType     string           `position:"Query" name:"MatchType"`
	Algorithm     string           `position:"Query" name:"Algorithm"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SearchKeyword string           `position:"Query" name:"SearchKeyword"`
}

// DescribeDcdnSSLCertificateListResponse is the response struct for api DescribeDcdnSSLCertificateList
type DescribeDcdnSSLCertificateListResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	CertificateListModel CertificateListModel `json:"CertificateListModel" xml:"CertificateListModel"`
}

// CreateDescribeDcdnSSLCertificateListRequest creates a request to invoke DescribeDcdnSSLCertificateList API
func CreateDescribeDcdnSSLCertificateListRequest() (request *DescribeDcdnSSLCertificateListRequest) {
	request = &DescribeDcdnSSLCertificateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnSSLCertificateList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnSSLCertificateListResponse creates a response to parse from DescribeDcdnSSLCertificateList response
func CreateDescribeDcdnSSLCertificateListResponse() (response *DescribeDcdnSSLCertificateListResponse) {
	response = &DescribeDcdnSSLCertificateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
