package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnSubTask invokes the dcdn.DeleteDcdnSubTask API synchronously
func (client *Client) DeleteDcdnSubTask(request *DeleteDcdnSubTaskRequest) (response *DeleteDcdnSubTaskResponse, err error) {
	response = CreateDeleteDcdnSubTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnSubTaskWithChan invokes the dcdn.DeleteDcdnSubTask API asynchronously
func (client *Client) DeleteDcdnSubTaskWithChan(request *DeleteDcdnSubTaskRequest) (<-chan *DeleteDcdnSubTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnSubTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnSubTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnSubTaskWithCallback invokes the dcdn.DeleteDcdnSubTask API asynchronously
func (client *Client) DeleteDcdnSubTaskWithCallback(request *DeleteDcdnSubTaskRequest, callback func(response *DeleteDcdnSubTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnSubTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnSubTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnSubTaskRequest is the request struct for api DeleteDcdnSubTask
type DeleteDcdnSubTaskRequest struct {
	*requests.RpcRequest
}

// DeleteDcdnSubTaskResponse is the response struct for api DeleteDcdnSubTask
type DeleteDcdnSubTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnSubTaskRequest creates a request to invoke DeleteDcdnSubTask API
func CreateDeleteDcdnSubTaskRequest() (request *DeleteDcdnSubTaskRequest) {
	request = &DeleteDcdnSubTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnSubTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnSubTaskResponse creates a response to parse from DeleteDcdnSubTask response
func CreateDeleteDcdnSubTaskResponse() (response *DeleteDcdnSubTaskResponse) {
	response = &DeleteDcdnSubTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
