package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCheckProcesses invokes the dataworks_public.ListCheckProcesses API synchronously
func (client *Client) ListCheckProcesses(request *ListCheckProcessesRequest) (response *ListCheckProcessesResponse, err error) {
	response = CreateListCheckProcessesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCheckProcessesWithChan invokes the dataworks_public.ListCheckProcesses API asynchronously
func (client *Client) ListCheckProcessesWithChan(request *ListCheckProcessesRequest) (<-chan *ListCheckProcessesResponse, <-chan error) {
	responseChan := make(chan *ListCheckProcessesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCheckProcesses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCheckProcessesWithCallback invokes the dataworks_public.ListCheckProcesses API asynchronously
func (client *Client) ListCheckProcessesWithCallback(request *ListCheckProcessesRequest, callback func(response *ListCheckProcessesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCheckProcessesResponse
		var err error
		defer close(result)
		response, err = client.ListCheckProcesses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCheckProcessesRequest is the request struct for api ListCheckProcesses
type ListCheckProcessesRequest struct {
	*requests.RpcRequest
	MessageId  string           `position:"Body" name:"MessageId"`
	Operator   string           `position:"Body" name:"Operator"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	ProjectId  requests.Integer `position:"Body" name:"ProjectId"`
	EventCode  string           `position:"Body" name:"EventCode"`
	Status     string           `position:"Body" name:"Status"`
}

// ListCheckProcessesResponse is the response struct for api ListCheckProcesses
type ListCheckProcessesResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PagingInfo PagingInfo `json:"PagingInfo" xml:"PagingInfo"`
}

// CreateListCheckProcessesRequest creates a request to invoke ListCheckProcesses API
func CreateListCheckProcessesRequest() (request *ListCheckProcessesRequest) {
	request = &ListCheckProcessesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListCheckProcesses", "", "")
	request.Method = requests.POST
	return
}

// CreateListCheckProcessesResponse creates a response to parse from ListCheckProcesses response
func CreateListCheckProcessesResponse() (response *ListCheckProcessesResponse) {
	response = &ListCheckProcessesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
