package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgDesensPlanDelete invokes the dataworks_public.DsgDesensPlanDelete API synchronously
func (client *Client) DsgDesensPlanDelete(request *DsgDesensPlanDeleteRequest) (response *DsgDesensPlanDeleteResponse, err error) {
	response = CreateDsgDesensPlanDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// DsgDesensPlanDeleteWithChan invokes the dataworks_public.DsgDesensPlanDelete API asynchronously
func (client *Client) DsgDesensPlanDeleteWithChan(request *DsgDesensPlanDeleteRequest) (<-chan *DsgDesensPlanDeleteResponse, <-chan error) {
	responseChan := make(chan *DsgDesensPlanDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgDesensPlanDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgDesensPlanDeleteWithCallback invokes the dataworks_public.DsgDesensPlanDelete API asynchronously
func (client *Client) DsgDesensPlanDeleteWithCallback(request *DsgDesensPlanDeleteRequest, callback func(response *DsgDesensPlanDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgDesensPlanDeleteResponse
		var err error
		defer close(result)
		response, err = client.DsgDesensPlanDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgDesensPlanDeleteRequest is the request struct for api DsgDesensPlanDelete
type DsgDesensPlanDeleteRequest struct {
	*requests.RpcRequest
	SceneCode string    `position:"Query" name:"SceneCode"`
	Ids       *[]string `position:"Query" name:"Ids"  type:"Json"`
}

// DsgDesensPlanDeleteResponse is the response struct for api DsgDesensPlanDelete
type DsgDesensPlanDeleteResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDsgDesensPlanDeleteRequest creates a request to invoke DsgDesensPlanDelete API
func CreateDsgDesensPlanDeleteRequest() (request *DsgDesensPlanDeleteRequest) {
	request = &DsgDesensPlanDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgDesensPlanDelete", "", "")
	request.Method = requests.POST
	return
}

// CreateDsgDesensPlanDeleteResponse creates a response to parse from DsgDesensPlanDelete response
func CreateDsgDesensPlanDeleteResponse() (response *DsgDesensPlanDeleteResponse) {
	response = &DsgDesensPlanDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
