package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDIAlarmRule invokes the dataworks_public.CreateDIAlarmRule API synchronously
func (client *Client) CreateDIAlarmRule(request *CreateDIAlarmRuleRequest) (response *CreateDIAlarmRuleResponse, err error) {
	response = CreateCreateDIAlarmRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDIAlarmRuleWithChan invokes the dataworks_public.CreateDIAlarmRule API asynchronously
func (client *Client) CreateDIAlarmRuleWithChan(request *CreateDIAlarmRuleRequest) (<-chan *CreateDIAlarmRuleResponse, <-chan error) {
	responseChan := make(chan *CreateDIAlarmRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDIAlarmRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDIAlarmRuleWithCallback invokes the dataworks_public.CreateDIAlarmRule API asynchronously
func (client *Client) CreateDIAlarmRuleWithCallback(request *CreateDIAlarmRuleRequest, callback func(response *CreateDIAlarmRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDIAlarmRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateDIAlarmRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDIAlarmRuleRequest is the request struct for api CreateDIAlarmRule
type CreateDIAlarmRuleRequest struct {
	*requests.RpcRequest
	MetricType           string           `position:"Body" name:"MetricType"`
	TriggerConditions    string           `position:"Body" name:"TriggerConditions"`
	Description          string           `position:"Body" name:"Description"`
	NotificationSettings string           `position:"Body" name:"NotificationSettings"`
	Enabled              requests.Boolean `position:"Body" name:"Enabled"`
	DIJobId              requests.Integer `position:"Body" name:"DIJobId"`
}

// CreateDIAlarmRuleResponse is the response struct for api CreateDIAlarmRule
type CreateDIAlarmRuleResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	DIAlarmRuleId int64  `json:"DIAlarmRuleId" xml:"DIAlarmRuleId"`
}

// CreateCreateDIAlarmRuleRequest creates a request to invoke CreateDIAlarmRule API
func CreateCreateDIAlarmRuleRequest() (request *CreateDIAlarmRuleRequest) {
	request = &CreateDIAlarmRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateDIAlarmRule", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDIAlarmRuleResponse creates a response to parse from CreateDIAlarmRule response
func CreateCreateDIAlarmRuleResponse() (response *CreateDIAlarmRuleResponse) {
	response = &CreateDIAlarmRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
