package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMySQLAllSessionAsync invokes the das.GetMySQLAllSessionAsync API synchronously
func (client *Client) GetMySQLAllSessionAsync(request *GetMySQLAllSessionAsyncRequest) (response *GetMySQLAllSessionAsyncResponse, err error) {
	response = CreateGetMySQLAllSessionAsyncResponse()
	err = client.DoAction(request, response)
	return
}

// GetMySQLAllSessionAsyncWithChan invokes the das.GetMySQLAllSessionAsync API asynchronously
func (client *Client) GetMySQLAllSessionAsyncWithChan(request *GetMySQLAllSessionAsyncRequest) (<-chan *GetMySQLAllSessionAsyncResponse, <-chan error) {
	responseChan := make(chan *GetMySQLAllSessionAsyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMySQLAllSessionAsync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMySQLAllSessionAsyncWithCallback invokes the das.GetMySQLAllSessionAsync API asynchronously
func (client *Client) GetMySQLAllSessionAsyncWithCallback(request *GetMySQLAllSessionAsyncRequest, callback func(response *GetMySQLAllSessionAsyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMySQLAllSessionAsyncResponse
		var err error
		defer close(result)
		response, err = client.GetMySQLAllSessionAsync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMySQLAllSessionAsyncRequest is the request struct for api GetMySQLAllSessionAsync
type GetMySQLAllSessionAsyncRequest struct {
	*requests.RpcRequest
	ResultId   string `position:"Query" name:"ResultId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	NodeId     string `position:"Query" name:"NodeId"`
}

// GetMySQLAllSessionAsyncResponse is the response struct for api GetMySQLAllSessionAsync
type GetMySQLAllSessionAsyncResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMySQLAllSessionAsyncRequest creates a request to invoke GetMySQLAllSessionAsync API
func CreateGetMySQLAllSessionAsyncRequest() (request *GetMySQLAllSessionAsyncRequest) {
	request = &GetMySQLAllSessionAsyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetMySQLAllSessionAsync", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMySQLAllSessionAsyncResponse creates a response to parse from GetMySQLAllSessionAsync response
func CreateGetMySQLAllSessionAsyncResponse() (response *GetMySQLAllSessionAsyncResponse) {
	response = &GetMySQLAllSessionAsyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
