package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindProjectStatisticalData invokes the csb.FindProjectStatisticalData API synchronously
// api document: https://help.aliyun.com/api/csb/findprojectstatisticaldata.html
func (client *Client) FindProjectStatisticalData(request *FindProjectStatisticalDataRequest) (response *FindProjectStatisticalDataResponse, err error) {
	response = CreateFindProjectStatisticalDataResponse()
	err = client.DoAction(request, response)
	return
}

// FindProjectStatisticalDataWithChan invokes the csb.FindProjectStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/csb/findprojectstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindProjectStatisticalDataWithChan(request *FindProjectStatisticalDataRequest) (<-chan *FindProjectStatisticalDataResponse, <-chan error) {
	responseChan := make(chan *FindProjectStatisticalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindProjectStatisticalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindProjectStatisticalDataWithCallback invokes the csb.FindProjectStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/csb/findprojectstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindProjectStatisticalDataWithCallback(request *FindProjectStatisticalDataRequest, callback func(response *FindProjectStatisticalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindProjectStatisticalDataResponse
		var err error
		defer close(result)
		response, err = client.FindProjectStatisticalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindProjectStatisticalDataRequest is the request struct for api FindProjectStatisticalData
type FindProjectStatisticalDataRequest struct {
	*requests.RpcRequest
	ProjectName string           `position:"Query" name:"ProjectName"`
	CsbId       requests.Integer `position:"Query" name:"CsbId"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
}

// FindProjectStatisticalDataResponse is the response struct for api FindProjectStatisticalData
type FindProjectStatisticalDataResponse struct {
	*responses.BaseResponse
	Code      int                              `json:"Code" xml:"Code"`
	Message   string                           `json:"Message" xml:"Message"`
	RequestId string                           `json:"RequestId" xml:"RequestId"`
	Data      DataInFindProjectStatisticalData `json:"Data" xml:"Data"`
}

// CreateFindProjectStatisticalDataRequest creates a request to invoke FindProjectStatisticalData API
func CreateFindProjectStatisticalDataRequest() (request *FindProjectStatisticalDataRequest) {
	request = &FindProjectStatisticalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "FindProjectStatisticalData", "", "")
	request.Method = requests.GET
	return
}

// CreateFindProjectStatisticalDataResponse creates a response to parse from FindProjectStatisticalData response
func CreateFindProjectStatisticalDataResponse() (response *FindProjectStatisticalDataResponse) {
	response = &FindProjectStatisticalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
