package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAddons invokes the cs.DescribeAddons API synchronously
func (client *Client) DescribeAddons(request *DescribeAddonsRequest) (response *DescribeAddonsResponse, err error) {
	response = CreateDescribeAddonsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAddonsWithChan invokes the cs.DescribeAddons API asynchronously
func (client *Client) DescribeAddonsWithChan(request *DescribeAddonsRequest) (<-chan *DescribeAddonsResponse, <-chan error) {
	responseChan := make(chan *DescribeAddonsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAddons(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAddonsWithCallback invokes the cs.DescribeAddons API asynchronously
func (client *Client) DescribeAddonsWithCallback(request *DescribeAddonsRequest, callback func(response *DescribeAddonsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAddonsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAddons(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAddonsRequest is the request struct for api DescribeAddons
type DescribeAddonsRequest struct {
	*requests.RoaRequest
	ClusterType string `position:"Query" name:"cluster_type"`
	Region      string `position:"Query" name:"region"`
}

// DescribeAddonsResponse is the response struct for api DescribeAddons
type DescribeAddonsResponse struct {
	*responses.BaseResponse
	StandardComponents map[string]interface{} `json:"StandardComponents" xml:"StandardComponents"`
	ComponentGroups    []ComponentGroup       `json:"ComponentGroups" xml:"ComponentGroups"`
}

// CreateDescribeAddonsRequest creates a request to invoke DescribeAddons API
func CreateDescribeAddonsRequest() (request *DescribeAddonsRequest) {
	request = &DescribeAddonsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeAddons", "/clusters/components/metadata", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAddonsResponse creates a response to parse from DescribeAddons response
func CreateDescribeAddonsResponse() (response *DescribeAddonsResponse) {
	response = &DescribeAddonsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
