package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRemediation invokes the config.UpdateRemediation API synchronously
func (client *Client) UpdateRemediation(request *UpdateRemediationRequest) (response *UpdateRemediationResponse, err error) {
	response = CreateUpdateRemediationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRemediationWithChan invokes the config.UpdateRemediation API asynchronously
func (client *Client) UpdateRemediationWithChan(request *UpdateRemediationRequest) (<-chan *UpdateRemediationResponse, <-chan error) {
	responseChan := make(chan *UpdateRemediationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRemediation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRemediationWithCallback invokes the config.UpdateRemediation API asynchronously
func (client *Client) UpdateRemediationWithCallback(request *UpdateRemediationRequest, callback func(response *UpdateRemediationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRemediationResponse
		var err error
		defer close(result)
		response, err = client.UpdateRemediation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRemediationRequest is the request struct for api UpdateRemediation
type UpdateRemediationRequest struct {
	*requests.RpcRequest
	ConfigRuleId          string `position:"Body" name:"ConfigRuleId"`
	RemediationType       string `position:"Body" name:"RemediationType"`
	ClientToken           string `position:"Body" name:"ClientToken"`
	RemediationId         string `position:"Body" name:"RemediationId"`
	SourceType            string `position:"Body" name:"SourceType"`
	RemediationTemplateId string `position:"Body" name:"RemediationTemplateId"`
	Params                string `position:"Body" name:"Params"`
	InvokeType            string `position:"Body" name:"InvokeType"`
}

// UpdateRemediationResponse is the response struct for api UpdateRemediation
type UpdateRemediationResponse struct {
	*responses.BaseResponse
	Data          string `json:"Data" xml:"Data"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	RemediationId string `json:"RemediationId" xml:"RemediationId"`
}

// CreateUpdateRemediationRequest creates a request to invoke UpdateRemediation API
func CreateUpdateRemediationRequest() (request *UpdateRemediationRequest) {
	request = &UpdateRemediationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "UpdateRemediation", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRemediationResponse creates a response to parse from UpdateRemediation response
func CreateUpdateRemediationResponse() (response *UpdateRemediationResponse) {
	response = &UpdateRemediationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
